/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.mojang.serialization.DynamicOps;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public abstract class SpecialBaseSpawner {
    private static final Logger LOGGER = ValhelsiaStructures.LOGGER;
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    private SpawnData nextSpawnData = new SpawnData();
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 80;
    private int maxSpawnDelay = 100;
    private int spawnCount = 5;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 7;
    private int requiredPlayerRange = 8;
    private int spawnRange = 4;
    private short waveCount = 0;

    public void setEntityId(EntityType<?> type) {
        this.nextSpawnData.m_186567_().m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(type)).toString());
    }

    private boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(Level level, BlockPos pos) {
        if (!this.isNearPlayer(level, pos)) {
            this.oSpin = this.spin;
        } else {
            double d0 = (double)pos.m_123341_() + level.f_46441_.nextDouble();
            double d1 = (double)pos.m_123342_() + level.f_46441_.nextDouble();
            double d2 = (double)pos.m_123343_() + level.f_46441_.nextDouble();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(@Nonnull ServerLevel serverLevel, @Nonnull BlockPos pos) {
        if (this.isNearPlayer((Level)serverLevel, pos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)serverLevel, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    Mob mob;
                    double d2;
                    CompoundTag compoundtag = this.nextSpawnData.m_186567_();
                    Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
                    if (optional.isEmpty()) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    ListTag listTag = compoundtag.m_128437_("Pos", 6);
                    int j = listTag.size();
                    double d0 = j >= 1 ? listTag.m_128772_(0) : (double)pos.m_123341_() + (serverLevel.f_46441_.nextDouble() - serverLevel.f_46441_.nextDouble()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? listTag.m_128772_(1) : (double)(pos.m_123342_() + serverLevel.f_46441_.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? listTag.m_128772_(2) : (double)pos.m_123343_() + (serverLevel.f_46441_.nextDouble() - serverLevel.f_46441_.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!serverLevel.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2))) continue;
                    Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)serverLevel, e -> {
                        e.m_7678_(d0, d1, d2, e.m_146908_(), e.m_146909_());
                        return e;
                    });
                    if (entity == null) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    int k = serverLevel.m_45976_(entity.getClass(), new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), serverLevel.f_46441_.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        if (this.nextSpawnData.m_186567_().m_128440_() == 1 && this.nextSpawnData.m_186567_().m_128425_("id", 8)) {
                            mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(entity.m_142538_()), MobSpawnType.SPAWNER, null, null);
                        }
                    }
                    if (!serverLevel.m_8860_(entity)) {
                        this.delay((Level)serverLevel, pos);
                        return;
                    }
                    serverLevel.m_46796_(2004, pos, 0);
                    if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        mob.m_21373_();
                    }
                    flag = true;
                    if (!(serverLevel.m_5822_().nextDouble() <= 0.1 * (double)(this.waveCount + 1) && this.waveCount >= 1) && this.waveCount < 3) continue;
                    serverLevel.m_46961_(pos, true);
                }
                if (flag) {
                    this.delay((Level)serverLevel, pos);
                    this.waveCount = (short)(this.waveCount + 1);
                }
            }
        }
    }

    private void delay(Level level, BlockPos pos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + level.m_5822_().nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.m_146335_(level.m_5822_()).ifPresent(spawnData -> this.setNextSpawnData(level, pos, (SpawnData)spawnData.m_146310_()));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        this.spawnDelay = tag.m_128448_("Delay");
        boolean flag = tag.m_128425_("SpawnPotentials", 9);
        boolean flag1 = tag.m_128425_("SpawnData", 10);
        if (!flag) {
            SpawnData spawndata = flag1 ? SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("SpawnData")).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new) : new SpawnData();
            this.spawnPotentials = SimpleWeightedRandomList.m_185862_((Object)spawndata);
            this.setNextSpawnData(level, pos, spawndata);
        } else {
            ListTag listtag = tag.m_128437_("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.f_186560_.parse((DynamicOps)NbtOps.f_128958_, (Object)listtag).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::m_185864_);
            if (flag1) {
                SpawnData spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("SpawnData")).resultOrPartial(p_186380_ -> LOGGER.warn("Invalid SpawnData: {}", p_186380_)).orElseGet(SpawnData::new);
                this.setNextSpawnData(level, pos, spawnData);
            } else {
                this.spawnPotentials.m_146335_(Objects.requireNonNull(level).m_5822_()).ifPresent(p_186378_ -> this.setNextSpawnData(level, pos, (SpawnData)p_186378_.m_146310_()));
            }
        }
        if (tag.m_128425_("MinSpawnDelay", 99)) {
            this.minSpawnDelay = tag.m_128448_("MinSpawnDelay");
            this.maxSpawnDelay = tag.m_128448_("MaxSpawnDelay");
            this.spawnCount = tag.m_128448_("SpawnCount");
        }
        if (tag.m_128425_("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = tag.m_128448_("MaxNearbyEntities");
            this.requiredPlayerRange = tag.m_128448_("RequiredPlayerRange");
        }
        if (tag.m_128425_("SpawnRange", 99)) {
            this.spawnRange = tag.m_128448_("SpawnRange");
        }
        if (tag.m_128441_("WaveCount")) {
            this.waveCount = tag.m_128448_("WaveCount");
        }
        this.displayEntity = null;
    }

    public CompoundTag save(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        tag.m_128376_("Delay", (short)this.spawnDelay);
        tag.m_128376_("MinSpawnDelay", (short)this.minSpawnDelay);
        tag.m_128376_("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tag.m_128376_("SpawnCount", (short)this.spawnCount);
        tag.m_128376_("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.m_128376_("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.m_128376_("SpawnRange", (short)this.spawnRange);
        tag.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        tag.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.spawnPotentials).result().orElseThrow());
        tag.m_128376_("WaveCount", this.waveCount);
        return tag;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level) {
        if (this.displayEntity == null) {
            this.displayEntity = EntityType.m_20645_((CompoundTag)this.nextSpawnData.m_186567_(), (Level)level, Function.identity());
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level level, int i) {
        if (i == 1) {
            if (level.f_46443_) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData spawnData) {
        this.nextSpawnData = spawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }
}

