/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.common.world.structures.StructureSettings;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.valhelsia.valhelsia_core.common.world.ValhelsiaJigsawStructure;

public abstract class AbstractValhelsiaStructure
extends ValhelsiaJigsawStructure<JigsawConfiguration> {
    private final StructureSettings structureSettings;
    private final ResourceKey<StructureSet> structureSetResourceKey;

    public AbstractValhelsiaStructure(Codec<JigsawConfiguration> codec, String name, Predicate<PieceGeneratorSupplier.Context<JigsawConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<JigsawConfiguration>, Optional<PieceGenerator<JigsawConfiguration>>> pieceCreationPredicate, StructureSettings structureSettings) {
        super(codec, name, locationCheckPredicate, pieceCreationPredicate);
        this.structureSettings = structureSettings;
        this.structureSetResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)new ResourceLocation("valhelsia_structures", name + "s"));
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        BlockPos pos = chunkPos.m_45615_();
        ChunkGenerator generator = context.f_197352_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        if (this.checkSurface() && !StructureUtils.isSurfaceFlat(context, this.getSize())) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            int landHeight = generator.m_156179_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = generator.m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        List<ResourceKey<StructureSet>> structures = ModStructures.MOD_STRUCTURES.stream().filter(structure -> structure.m_67095_() == this.m_67095_() && structure.getStructureSetResourceKey() != this.getStructureSetResourceKey()).map(AbstractValhelsiaStructure::getStructureSetResourceKey).toList();
        if (StructureUtils.isStructureInDistance(generator, context.f_197354_(), context.f_197355_(), structures)) {
            return false;
        }
        random.setSeed((long)(chunkPos.f_45578_ >> 4 ^ chunkPos.f_45579_ >> 4 << 4) ^ context.f_197354_());
        return random.nextDouble() < this.getSpawnChance();
    }

    @Nonnull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public boolean transformsSurroundingLand() {
        return true;
    }

    public abstract Pair<Integer, Integer> getSize();

    public StructureSettings getStructureSettings() {
        return this.structureSettings;
    }

    public ResourceKey<StructureSet> getStructureSetResourceKey() {
        return this.structureSetResourceKey;
    }

    public int getSpacing() {
        return Math.max(this.getStructureSettings().spacing().get(), this.getSeparation() + 1);
    }

    public int getSeparation() {
        return this.getStructureSettings().separation().get();
    }

    public abstract int getSeedModifier();

    public double getSpawnChance() {
        return this.getStructureSettings().spawnChance().get();
    }

    public abstract Holder<ConfiguredStructureFeature<?, ?>> getStructureFeature();

    public boolean checkSurface() {
        return true;
    }

    public boolean canGenerateOnWater() {
        return false;
    }

    public boolean hasMargin() {
        return true;
    }

    public int getMargin() {
        return 12;
    }

    public int getGenerationHeight() {
        return -1;
    }

    public Optional<PieceGenerator<JigsawConfiguration>> generatePieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        boolean flag = this.getGenerationHeight() == -1;
        BlockPos pos = context.f_197355_().m_151394_(flag ? 0 : this.getGenerationHeight());
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)pos, (boolean)true, (boolean)flag);
    }
}

