/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.villagertools;

import com.lothrazar.villagertools.AngerUtils;
import com.lothrazar.villagertools.ModRegistry;
import com.lothrazar.villagertools.entities.FriendGolem;
import com.lothrazar.villagertools.entities.GuardVindicator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof GuardVindicator && event.getSource() != null && event.getSource().m_7640_() instanceof IronGolem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        IronGolem golem;
        if (event.getEntityLiving() instanceof IronGolem && (golem = (IronGolem)event.getEntityLiving()).m_5448_() instanceof GuardVindicator) {
            AngerUtils.makeCalmGolem(golem);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getPos() == null || event.getFace() == null) {
            return;
        }
        BlockPos pos = event.getPos().m_142300_(event.getFace());
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        Level world = player.f_19853_;
        if (stack.m_41720_() == ModRegistry.BADGE.get()) {
            Pillager child = (Pillager)EntityType.f_20513_.m_20615_(world);
            child.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            child.m_21446_(pos, world.f_46441_.nextInt(20) + 10);
            world.m_7967_((Entity)child);
            child = (Pillager)EntityType.f_20513_.m_20615_(world);
            child.m_6034_((double)(pos.m_123341_() + world.f_46441_.nextInt(5)), (double)pos.m_123342_(), (double)(pos.m_123343_() + world.f_46441_.nextInt(5)));
            child.m_21446_(pos, world.f_46441_.nextInt(20) + 10);
            world.m_7967_((Entity)child);
            child = (Pillager)EntityType.f_20513_.m_20615_(world);
            child.m_6034_((double)(pos.m_123341_() + world.f_46441_.nextInt(5)), (double)pos.m_123342_(), (double)(pos.m_123343_() + world.f_46441_.nextInt(5)));
            child.m_21446_(pos, world.f_46441_.nextInt(20) + 10);
            world.m_7967_((Entity)child);
            this.onComplete(player, event.getHand(), stack);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        Villager vil;
        ItemStack stack = event.getItemStack();
        Player player = event.getPlayer();
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        Level world = player.f_19853_;
        Entity targetEnt = event.getTarget();
        EntityType targetType = targetEnt.m_6095_();
        BlockPos pos = targetEnt.m_142538_();
        if (stack.m_41720_() == ModRegistry.CURE.get() && targetType == EntityType.f_20530_) {
            ZombieVillager trader = (ZombieVillager)targetEnt;
            trader.m_34383_(player.m_142081_(), world.f_46441_.nextInt(2401) + 3600);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.CONTRACT.get() && targetEnt instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)targetEnt;
            Villager villagerChild = (Villager)trader.m_21406_(EntityType.f_20492_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.GEARS.get() && targetType == EntityType.f_20460_) {
            IronGolem trader = (IronGolem)targetEnt;
            FriendGolem villagerChild = (FriendGolem)((EntityType)ModRegistry.GOLEM.get()).m_20615_(world);
            villagerChild.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetEnt instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)targetEnt;
            Evoker villagerChild = (Evoker)trader.m_21406_(EntityType.f_20568_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetEnt instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)targetEnt;
            Evoker villagerChild = (Evoker)trader.m_21406_(EntityType.f_20568_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetType == EntityType.f_20494_ && targetEnt instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)targetEnt;
            Illusioner villagerChild = (Illusioner)trader.m_21406_(EntityType.f_20459_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetEnt instanceof Cow) {
            Cow trader = (Cow)targetEnt;
            Ravager villagerChild = (Ravager)trader.m_21406_(EntityType.f_20518_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetType == EntityType.f_20492_) {
            Villager vil2 = (Villager)targetEnt;
            Witch villagerChild = (Witch)vil2.m_21406_(EntityType.f_20495_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)vil2);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetType == EntityType.f_20513_) {
            Pillager vil3 = (Pillager)targetEnt;
            Evoker villagerChild = (Evoker)vil3.m_21406_(EntityType.f_20568_, false);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)vil3);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.DARKNESS.get() && targetType == ModRegistry.GUARDENTITY.get()) {
            GuardVindicator trader = (GuardVindicator)targetEnt;
            Pillager child = (Pillager)EntityType.f_20513_.m_20615_(world);
            child.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            child.m_21446_(pos, world.f_46441_.nextInt(20) + 10);
            world.m_7967_((Entity)child);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.GUARD_ITEM.get() && targetEnt instanceof Raider) {
            Raider trader = (Raider)targetEnt;
            GuardVindicator villagerChild = (GuardVindicator)((EntityType)ModRegistry.GUARDENTITY.get()).m_20615_(world);
            villagerChild.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            villagerChild.m_21446_(pos, 30);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.GUARD_ITEM.get() && targetType == EntityType.f_20495_) {
            Witch trader = (Witch)targetEnt;
            GuardVindicator villagerChild = (GuardVindicator)((EntityType)ModRegistry.GUARDENTITY.get()).m_20615_(world);
            villagerChild.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            villagerChild.m_21446_(pos, 30);
            world.m_7967_((Entity)villagerChild);
            this.removeEntity(world, (Entity)trader);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.KEY.get() && targetType == EntityType.f_20488_) {
            TraderLlama tradeLlama = (TraderLlama)targetEnt;
            Llama llamaChild = (Llama)tradeLlama.m_21406_(EntityType.f_20466_, false);
            world.m_7967_((Entity)llamaChild);
            this.removeEntity(world, (Entity)tradeLlama);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.RESTOCK.get() && targetType == EntityType.f_20492_) {
            Villager vil4 = (Villager)targetEnt;
            this.restock(vil4);
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.FORGET.get() && targetType == EntityType.f_20492_) {
            Villager vil5 = (Villager)targetEnt;
            vil5.m_141967_(vil5.m_7141_().m_35565_(VillagerProfession.f_35585_).m_35561_(0));
            this.onComplete(player, event.getHand(), stack);
        } else if (stack.m_41720_() == ModRegistry.KNOWLEDGE.get() && targetType == EntityType.f_20492_) {
            Villager vil6 = (Villager)targetEnt;
            int level = vil6.m_7141_().m_35576_();
            if (level < 5) {
                vil6.m_35528_();
                this.onComplete(player, event.getHand(), stack);
            }
        } else if (stack.m_41720_() == ModRegistry.BRIBE.get() && targetType == EntityType.f_20492_ && (vil = (Villager)targetEnt).m_35532_(player) < 100) {
            if (!world.f_46443_) {
                int before = vil.m_35532_(player);
                vil.m_6814_(ReputationEventType.f_26989_, (Entity)player);
                vil.m_6814_(ReputationEventType.f_26989_, (Entity)player);
                vil.m_6814_(ReputationEventType.f_26989_, (Entity)player);
                int diff = vil.m_35532_(player) - before;
                TranslatableComponent t = new TranslatableComponent(stack.m_41778_() + ".rep");
                t.m_130946_("" + diff);
                player.m_5661_((Component)t, false);
            }
            this.onComplete(player, event.getHand(), stack);
        }
    }

    private void removeEntity(Level world, Entity trader) {
        if (world instanceof ServerLevel) {
            ((ServerLevel)world).removeEntity(trader);
        }
    }

    private void onComplete(Player player, InteractionHand hand, ItemStack stack) {
        player.m_6674_(hand);
        player.m_36335_().m_41524_(stack.m_41720_(), 30);
        if (player.f_19853_.f_46443_) {
            player.m_5661_((Component)new TranslatableComponent(stack.m_41778_() + ".used"), false);
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    private void restock(Villager vil) {
        vil.m_35510_();
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("LastRestock", 0L);
        vil.m_7378_(compound);
    }

    @SubscribeEvent
    public void onVillagerStart(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Villager) {
            this.tryAddAi((Villager)event.getEntity());
        }
    }

    private void tryAddAi(Villager vil) {
        if (vil.f_21345_.f_25345_.stream().anyMatch(g -> g.m_26015_() instanceof TemptGoal)) {
            return;
        }
        try {
            vil.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)vil, 0.666, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.LURE.get()}), false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

