/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.particle;

import com.cursedcauldron.wildbackport.client.particle.ShriekParticleOptions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ShriekParticle
extends TextureSheetParticle {
    private static final Vector3f AXIS = (Vector3f)Util.m_137469_((Object)new Vector3f(0.5f, 0.5f, 0.5f), Vector3f::m_122278_);
    private static final Vector3f OFFSET = new Vector3f(-1.0f, -1.0f, 0.0f);
    private int delay;

    protected ShriekParticle(ClientLevel level, double x, double y, double z, int delay) {
        super(level, x, y, z);
        this.f_107663_ = 0.85f;
        this.delay = delay;
        this.f_107225_ = 30;
        this.f_107226_ = 0.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.1;
        this.f_107217_ = 0.0;
    }

    public float m_5902_(float tickDelta) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + tickDelta) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f);
    }

    public void m_5744_(VertexConsumer vertex, Camera camera, float tickDelta) {
        if (this.delay > 0) {
            return;
        }
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + tickDelta) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f);
        this.render(vertex, camera, tickDelta, quaternion -> {
            quaternion.m_80148_(Vector3f.f_122225_.m_122270_(0.0f));
            quaternion.m_80148_(Vector3f.f_122223_.m_122270_(-1.0472f));
        });
        this.render(vertex, camera, tickDelta, quaternion -> {
            quaternion.m_80148_(Vector3f.f_122225_.m_122270_((float)(-Math.PI)));
            quaternion.m_80148_(Vector3f.f_122223_.m_122270_(1.0472f));
        });
    }

    private void render(VertexConsumer vertex, Camera camera, float tickDelta, Consumer<Quaternion> consumer) {
        Vec3 pos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - pos.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - pos.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - pos.m_7094_());
        Quaternion quaternion = new Quaternion(AXIS, 0.0f, true);
        consumer.accept(quaternion);
        OFFSET.m_122251_(quaternion);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float quadSize = this.m_5902_(tickDelta);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector = vectors[i];
            vector.m_122251_(quaternion);
            vector.m_122261_(quadSize);
            vector.m_122272_(x, y, z);
        }
        int light = this.m_6355_(tickDelta);
        this.addVertex(vertex, vectors[0], this.m_5952_(), this.m_5950_(), light);
        this.addVertex(vertex, vectors[1], this.m_5952_(), this.m_5951_(), light);
        this.addVertex(vertex, vectors[2], this.m_5970_(), this.m_5951_(), light);
        this.addVertex(vertex, vectors[3], this.m_5970_(), this.m_5950_(), light);
    }

    private void addVertex(VertexConsumer vertex, Vector3f vector, float u, float v, int light) {
        vertex.m_5483_((double)vector.m_122239_(), (double)vector.m_122260_(), (double)vector.m_122269_()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    protected int m_6355_(float tint) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        super.m_5989_();
    }

    public record Provider(SpriteSet spriteSet) implements ParticleProvider<ShriekParticleOptions>
    {
        public Particle createParticle(ShriekParticleOptions options, ClientLevel level, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
            ShriekParticle particle = new ShriekParticle(level, x, y, z, options.delay());
            particle.m_108335_(this.spriteSet);
            particle.m_107271_(1.0f);
            return particle;
        }
    }
}

