/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render;

import com.cursedcauldron.wildbackport.client.render.model.Drawable;
import com.cursedcauldron.wildbackport.client.render.model.WardenModel;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.core.mixin.access.RenderStateShardAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.RenderTypeAccessor;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WardenLayerRenderer<T extends Warden, M extends WardenModel<T>>
extends RenderLayer<T, M> {
    public static final BiFunction<ResourceLocation, Boolean, RenderType> ENTITY_TRANSLUCENT_EMISSIVE = Util.m_143821_((location, create) -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(RenderStateShardAccessor.getRENDERTYPE_EYES_SHADER()).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(RenderStateShardAccessor.getTRANSLUCENT_TRANSPARENCY()).m_110661_(RenderStateShardAccessor.getNO_CULL()).m_110687_(RenderStateShardAccessor.getCOLOR_WRITE()).m_110677_(RenderStateShardAccessor.getOVERLAY()).m_110691_(create.booleanValue());
        return RenderTypeAccessor.callCreate("entity_translucent_emissive", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, compositeState);
    });
    private final ResourceLocation texture;
    private final AnimationAngleAdjuster<T> animationAngleAdjuster;
    private final ModelPartVisibility<T, M> modelPartVisibility;

    public WardenLayerRenderer(RenderLayerParent<T, M> ctx, ResourceLocation texture, AnimationAngleAdjuster<T> animationAngleAdjuster, ModelPartVisibility<T, M> modelPartVisibility) {
        super(ctx);
        this.texture = texture;
        this.animationAngleAdjuster = animationAngleAdjuster;
        this.modelPartVisibility = modelPartVisibility;
    }

    public void render(PoseStack stack, MultiBufferSource source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        if (!entity.m_20145_()) {
            this.updateModelPartVisibility();
            VertexConsumer consumer = source.m_6299_(ENTITY_TRANSLUCENT_EMISSIVE.apply(this.texture, true));
            ((WardenModel)this.m_117386_()).m_7695_(stack, consumer, light, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.animationAngleAdjuster.apply(entity, tickDelta, animationProgress));
            this.unhideAllModelParts();
        }
    }

    private void updateModelPartVisibility() {
        List<ModelPart> parts = this.modelPartVisibility.getPartsToDraw((WardenModel)this.m_117386_());
        ((WardenModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> Drawable.of(part).setSkipDraw(true));
        parts.forEach(part -> Drawable.of(part).setSkipDraw(false));
    }

    private void unhideAllModelParts() {
        ((WardenModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> Drawable.of(part).setSkipDraw(false));
    }

    public static interface AnimationAngleAdjuster<T extends Warden> {
        public float apply(T var1, float var2, float var3);
    }

    public static interface ModelPartVisibility<T extends Warden, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

