/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.client.render.model;

import com.cursedcauldron.wildbackport.client.animation.FrogAnimations;
import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.animation.api.AnimatedModel;
import com.cursedcauldron.wildbackport.common.entities.Frog;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FrogModel<T extends Frog>
extends AnimatedModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart eyes;
    private final ModelPart tongue;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart croakingBody;

    public FrogModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.eyes = this.head.m_171324_("eyes");
        this.tongue = this.body.m_171324_("tongue");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.croakingBody = this.body.m_171324_("croaking_body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition bone = root.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 1).m_171481_(-3.5f, -2.0f, -8.0f, 7.0f, 3.0f, 9.0f).m_171514_(23, 22).m_171481_(-3.5f, -1.0f, -8.0f, 7.0f, 0.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(23, 13).m_171481_(-3.5f, -1.0f, -7.0f, 7.0f, 0.0f, 9.0f).m_171514_(0, 13).m_171481_(-3.5f, -2.0f, -7.0f, 7.0f, 3.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)2.0f));
        eyes.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)-1.5f, (float)-3.0f, (float)-6.5f));
        eyes.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)2.5f, (float)-3.0f, (float)-6.5f));
        body.m_171599_("croaking_body", CubeListBuilder.m_171558_().m_171514_(26, 5).m_171488_(-3.5f, -0.1f, -2.9f, 7.0f, 2.0f, 3.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-5.0f));
        body.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(17, 13).m_171481_(-2.0f, 0.0f, -7.1f, 4.0f, 0.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)-1.01f, (float)1.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 3.0f), PartPose.m_171419_((float)4.0f, (float)-1.0f, (float)-6.5f));
        left_arm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(18, 40).m_171481_(-4.0f, 0.01f, -4.0f, 8.0f, 0.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)-6.5f));
        right_arm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(2, 40).m_171481_(-4.0f, 0.01f, -5.0f, 8.0f, 0.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(14, 25).m_171481_(-1.0f, 0.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.m_171419_((float)3.5f, (float)-3.0f, (float)4.0f));
        left_leg.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(2, 32).m_171481_(-4.0f, 0.01f, -4.0f, 8.0f, 0.0f, 8.0f), PartPose.m_171419_((float)2.0f, (float)3.0f, (float)0.0f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, 0.0f, -2.0f, 3.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-3.5f, (float)-3.0f, (float)4.0f));
        right_leg.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(18, 32).m_171481_(-4.0f, 0.01f, -4.0f, 8.0f, 0.0f, 8.0f), PartPose.m_171419_((float)-2.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)48, (int)48);
    }

    public void setupAnim(T entity, float angle, float distance, float animationProgress, float yaw, float pitch) {
        this.root.m_171331_().forEach(Animated::resetToDefault);
        float speedMultiplier = Math.min((float)entity.m_20184_().m_82556_() * 200.0f, 8.0f);
        this.animate(((Frog)((Object)entity)).longJumpingAnimationState, FrogAnimations.LONG_JUMPING, animationProgress);
        this.animate(((Frog)((Object)entity)).croakingAnimationState, FrogAnimations.CROAKING, animationProgress);
        this.animate(((Frog)((Object)entity)).usingTongueAnimationState, FrogAnimations.USING_TONGUE, animationProgress);
        this.animate(((Frog)((Object)entity)).walkingAnimationState, FrogAnimations.WALKING, animationProgress, speedMultiplier);
        this.animate(((Frog)((Object)entity)).swimmingAnimationState, FrogAnimations.SWIMMING, animationProgress);
        this.animate(((Frog)((Object)entity)).idlingInWaterAnimationState, FrogAnimations.IDLING_IN_WATER, animationProgress);
        this.croakingBody.f_104207_ = ((Frog)((Object)entity)).croakingAnimationState.isRunning();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

