/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.blocks.StateProperties;
import com.cursedcauldron.wildbackport.common.blocks.entity.SculkShriekerBlockEntity;
import com.cursedcauldron.wildbackport.common.entities.warden.VibrationHandler;
import com.cursedcauldron.wildbackport.common.registry.WBBlockEntities;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SculkShriekerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty SHRIEKING = StateProperties.SHRIEKING;
    public static final BooleanProperty CAN_SUMMON = StateProperties.CAN_SUMMON;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final double TOP_Y = SHAPE.m_83297_(Direction.Axis.Y);

    public SculkShriekerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SHRIEKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CAN_SUMMON, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHRIEKING, WATERLOGGED, CAN_SUMMON});
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ServerPlayer player = SculkShriekerBlockEntity.tryGetPlayer(entity);
            if (player != null) {
                server.m_141902_(pos, WBBlockEntities.SCULK_SHRIEKER.get()).ifPresent(shrieker -> shrieker.tryShriek(server, player));
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (((Boolean)state.m_61143_((Property)SHRIEKING)).booleanValue() && !state.m_60713_(newState.m_60734_())) {
                server.m_141902_(pos, WBBlockEntities.SCULK_SHRIEKER.get()).ifPresent(shrieker -> shrieker.tryRespond(server));
            }
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)SHRIEKING)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHRIEKING, (Comparable)Boolean.valueOf(false)), 3);
            level.m_141902_(pos, WBBlockEntities.SCULK_SHRIEKER.get()).ifPresent(shrieker -> shrieker.tryRespond(level));
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SculkShriekerBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, newState, level, pos, newPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_8101_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0) {
            this.m_49805_(level, pos, 5);
        }
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_142226_(Level level, T type) {
        VibrationHandler vibrationHandler;
        if (type instanceof SculkShriekerBlockEntity) {
            SculkShriekerBlockEntity shrieker = (SculkShriekerBlockEntity)type;
            vibrationHandler = shrieker.getListener();
        } else {
            vibrationHandler = null;
        }
        return vibrationHandler;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ ? SculkShriekerBlock.m_152132_(type, WBBlockEntities.SCULK_SHRIEKER.get(), (levelIn, posIn, stateIn, shrieker) -> shrieker.getListener().tick(levelIn)) : null;
    }
}

