/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import java.util.Collection;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public interface SculkSpreadable {
    public static final SculkSpreadable DEFAULT = new SculkSpreadable(){

        @Override
        public boolean spread(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Collection<Direction> directions, boolean postProcess) {
            if (directions == null) {
                return ((SculkVeinBlock)WBBlocks.SCULK_VEIN.get()).getSamePositionOnlyGrower().grow(level.m_8055_(pos), level, pos, postProcess) > 0L;
            }
            if (!directions.isEmpty()) {
                return (state.m_60795_() || state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) && SculkVeinBlock.place(level, pos, state, directions);
            }
            return SculkSpreadable.super.spread(level, pos, state, directions, postProcess);
        }

        @Override
        public int spread(SculkSpreadManager.Cursor cursor, LevelAccessor level, BlockPos pos, Random random, SculkSpreadManager spreadManager, boolean shouldConvert) {
            return cursor.getDecayDelay() > 0 ? cursor.getCharge() : 0;
        }

        @Override
        public int getDecay(int oldDecay) {
            return Math.max(oldDecay - 1, 0);
        }
    };

    default public byte getUpdate() {
        return 1;
    }

    default public void spreadAtSamePosition(LevelAccessor level, BlockState state, BlockPos pos, Random random) {
    }

    default public boolean spread(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Collection<Direction> directions, boolean postProcess) {
        return ((SculkVeinBlock)WBBlocks.SCULK_VEIN.get()).getAllGrowTypeGrower().grow(state, level, pos, postProcess) > 0L;
    }

    default public boolean shouldConvertToSpreadable() {
        return true;
    }

    default public int getDecay(int oldDecay) {
        return 1;
    }

    public int spread(SculkSpreadManager.Cursor var1, LevelAccessor var2, BlockPos var3, Random var4, SculkSpreadManager var5, boolean var6);
}

