/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.blocks;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.worldgen.VeinGrower;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkVeinBlock
extends MultifaceBlock
implements SculkSpreadable,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final VeinGrower allGrowTypeGrower = new VeinGrower(new SculkVeinGrowChecker(VeinGrower.GROW_TYPES));
    private final VeinGrower samePositionOnlyGrower = new VeinGrower(new SculkVeinGrowChecker(VeinGrower.GrowType.SAME_POSITION));

    public SculkVeinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VeinGrower getAllGrowTypeGrower() {
        return this.allGrowTypeGrower;
    }

    public VeinGrower getSamePositionOnlyGrower() {
        return this.samePositionOnlyGrower;
    }

    public static boolean place(LevelAccessor level, BlockPos pos, BlockState state, Collection<Direction> directions) {
        boolean canPlace = false;
        BlockState veinState = WBBlocks.SCULK_VEIN.get().m_49966_();
        for (Direction direction : directions) {
            BlockPos blockPos;
            if (!SculkVeinBlock.canGrowOn((BlockGetter)level, direction, blockPos = pos.m_142300_(direction), level.m_8055_(blockPos))) continue;
            veinState = (BlockState)veinState.m_61124_((Property)SculkVeinBlock.m_153933_((Direction)direction), (Comparable)Boolean.valueOf(true));
            canPlace = true;
        }
        if (!canPlace) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            veinState = (BlockState)veinState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        level.m_7731_(pos, veinState, 3);
        return true;
    }

    @Override
    public void spreadAtSamePosition(LevelAccessor level, BlockState state, BlockPos pos, Random random) {
        if (state.m_60713_((Block)this)) {
            for (Direction direction : f_153806_) {
                BooleanProperty property = SculkVeinBlock.m_153933_((Direction)direction);
                if (!((Boolean)state.m_61143_((Property)property)).booleanValue() || !level.m_8055_(pos.m_142300_(direction)).m_60713_(WBBlocks.SCULK.get())) continue;
                state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
            }
            if (!SculkVeinBlock.m_153960_((BlockState)state)) {
                FluidState fluid = level.m_6425_(pos);
                state = (fluid.m_76178_() ? Blocks.f_50016_ : Blocks.f_49990_).m_49966_();
            }
            level.m_7731_(pos, state, 3);
            SculkSpreadable.super.spreadAtSamePosition(level, state, pos, random);
        }
    }

    @Override
    public int spread(SculkSpreadManager.Cursor cursor, LevelAccessor level, BlockPos pos, Random random, SculkSpreadManager spreadManager, boolean shouldConvert) {
        if (shouldConvert && this.convertToBlock(spreadManager, level, cursor.getPos(), random)) {
            return cursor.getCharge() - 1;
        }
        return random.nextInt(spreadManager.getSpreadChance()) == 0 ? Mth.m_14143_((float)((float)cursor.getCharge() * 0.5f)) : cursor.getCharge();
    }

    private boolean convertToBlock(SculkSpreadManager spreadManager, LevelAccessor level, BlockPos pos, Random random) {
        BlockState state = level.m_8055_(pos);
        TagKey<Block> replaceable = spreadManager.getReplaceableBlocks();
        for (Direction direction : DirectionUtils.shuffle(random)) {
            BlockPos blockPos;
            BlockState blockState;
            if (!SculkVeinBlock.hasFace(state, direction) || !(blockState = level.m_8055_(blockPos = pos.m_142300_(direction))).m_204336_(replaceable)) continue;
            BlockState sculk = WBBlocks.SCULK.get().m_49966_();
            level.m_7731_(blockPos, sculk, 3);
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                Block.m_49897_((BlockState)blockState, (BlockState)sculk, (Level)server, (BlockPos)pos);
            }
            level.m_5594_(null, blockPos, WBSoundEvents.BLOCK_SCULK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.allGrowTypeGrower.grow(sculk, level, blockPos, spreadManager.isWorldGen());
            Direction opposite = direction.m_122424_();
            for (Direction towards : f_153806_) {
                BlockPos targetPos;
                BlockState targetState;
                if (towards == opposite || !(targetState = level.m_8055_(targetPos = blockPos.m_142300_(towards))).m_60713_((Block)this)) continue;
                this.spreadAtSamePosition(level, targetState, targetPos, random);
            }
            return true;
        }
        return false;
    }

    public static boolean veinCoversSculkReplaceable(LevelAccessor level, BlockState state, BlockPos pos) {
        if (state.m_60713_(WBBlocks.SCULK_VEIN.get())) {
            for (Direction direction : f_153806_) {
                if (!SculkVeinBlock.hasFace(state, direction) || !level.m_8055_(pos.m_142300_(direction)).m_204336_(WBBlockTags.SCULK_REPLACEABLE)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowWithDirection(BlockGetter getter, BlockState state, BlockPos pos, Direction direction) {
        if (!(!this.m_153920_(direction) || state.m_60713_((Block)this) && SculkVeinBlock.hasFace(state, direction))) {
            BlockPos blockPos = pos.m_142300_(direction);
            return SculkVeinBlock.canGrowOn(getter, direction, blockPos, getter.m_8055_(blockPos));
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_43722_().m_150930_(WBBlocks.SCULK_VEIN.get().m_5456_()) || super.m_6864_(state, context);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public PushReaction m_5537_(BlockState p_60584_) {
        return PushReaction.DESTROY;
    }

    public static byte directionsToFlag(Collection<Direction> directions) {
        byte flag = 0;
        for (Direction direction : directions) {
            flag = (byte)(flag | 1 << direction.ordinal());
        }
        return flag;
    }

    public static Set<Direction> collectDirections(BlockState state) {
        if (!(state.m_60734_() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> directions = EnumSet.noneOf(Direction.class);
        for (Direction direction : f_153806_) {
            if (!SculkVeinBlock.hasFace(state, direction)) continue;
            directions.add(direction);
        }
        return directions;
    }

    public static boolean canGrowOn(BlockGetter getter, Direction direction, BlockPos pos, BlockState state) {
        return Block.m_49918_((VoxelShape)state.m_60816_(getter, pos), (Direction)direction.m_122424_()) || Block.m_49918_((VoxelShape)state.m_60812_(getter, pos), (Direction)direction.m_122424_());
    }

    public static boolean hasFace(BlockState state, Direction direction) {
        BooleanProperty booleanProperty = MultifaceBlock.m_153933_((Direction)direction);
        return state.m_61138_((Property)booleanProperty) && (Boolean)state.m_61143_((Property)booleanProperty) != false;
    }

    class SculkVeinGrowChecker
    extends VeinGrower.VeinGrowChecker {
        private final VeinGrower.GrowType[] growTypes;

        public SculkVeinGrowChecker(VeinGrower.GrowType ... growTypes) {
            super(SculkVeinBlock.this);
            this.growTypes = growTypes;
        }

        @Override
        public boolean canGrow(BlockGetter getter, BlockPos pos, BlockPos growPos, Direction direction, BlockState state) {
            BlockPos blockPos;
            boolean flag;
            BlockState blockState = getter.m_8055_(growPos.m_142300_(direction));
            boolean bl = flag = blockState.m_60713_(WBBlocks.SCULK.get()) || blockState.m_60713_(WBBlocks.SCULK_CATALYST.get()) || blockState.m_60713_(Blocks.f_50110_);
            if (flag) {
                return false;
            }
            if (pos.m_123333_((Vec3i)growPos) == 2 && getter.m_8055_(blockPos = pos.m_142300_(direction.m_122424_())).m_60783_(getter, blockPos, direction)) {
                return false;
            }
            FluidState fluidState = state.m_60819_();
            if (!fluidState.m_76178_() && !fluidState.m_192917_((Fluid)Fluids.f_76193_)) {
                return false;
            }
            return state.m_60767_().m_76336_() || super.canGrow(getter, pos, growPos, direction, state);
        }

        @Override
        public VeinGrower.GrowType[] getGrowTypes() {
            return this.growTypes;
        }

        @Override
        public boolean canGrow(BlockState state) {
            return !state.m_60713_(WBBlocks.SCULK_VEIN.get());
        }
    }
}

