/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.client.animation.api.AnimationState;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.entities.brain.FrogBrain;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBSensorTypes;
import com.cursedcauldron.wildbackport.common.tag.WBBiomeTags;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.tag.WBEntityTypeTags;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Frog
extends Animal {
    public static final Ingredient FOOD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_});
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Frog>>> SENSORS = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, WBSensorTypes.FROG_ATTACKABLES.get(), WBSensorTypes.FROG_TEMPTATIONS.get(), WBSensorTypes.IS_IN_WATER.get());
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORIES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148199_, (Object)MemoryModuleType.f_148200_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148198_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_148194_, WBMemoryModules.IS_IN_WATER.get(), WBMemoryModules.IS_PREGNANT.get(), WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get()});
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<OptionalInt> TARGET = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    public final AnimationState longJumpingAnimationState = new AnimationState();
    public final AnimationState croakingAnimationState = new AnimationState();
    public final AnimationState usingTongueAnimationState = new AnimationState();
    public final AnimationState walkingAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState idlingInWaterAnimationState = new AnimationState();

    public Frog(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.f_21365_ = new FrogLookController((Mob)this);
        this.m_21441_(BlockPathTypes.WATER, 4.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_19793_ = 1.0f;
    }

    protected Brain.Provider<Frog> m_5490_() {
        return Brain.m_21923_(MEMORIES, SENSORS);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return FrogBrain.create((Brain<Frog>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Frog> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(TARGET, (Object)OptionalInt.empty());
    }

    public void clearFrogTarget() {
        this.f_19804_.m_135381_(TARGET, (Object)OptionalInt.empty());
    }

    public Optional<Entity> getFrogTarget() {
        return ((OptionalInt)this.f_19804_.m_135370_(TARGET)).stream().mapToObj(arg_0 -> ((Level)this.f_19853_).m_6815_(arg_0)).filter(Objects::nonNull).findFirst();
    }

    public void setFrogTarget(Entity entity) {
        this.f_19804_.m_135381_(TARGET, (Object)OptionalInt.of(entity.m_142049_()));
    }

    public int m_21529_() {
        return 35;
    }

    public int m_8085_() {
        return 5;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.getId());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().getId());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
    }

    public boolean m_6040_() {
        return true;
    }

    private boolean shouldWalk() {
        return this.f_19861_ && this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20072_();
    }

    private boolean shouldSwim() {
        return this.m_20184_().m_165925_() > 1.0E-6 && this.m_20072_();
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("frogBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("frogActivityUpdate");
        FrogBrain.updateActivities(this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            if (this.shouldWalk()) {
                this.walkingAnimationState.startIfNotRunning(this.f_19797_);
            } else {
                this.walkingAnimationState.stop();
            }
            if (this.shouldSwim()) {
                this.idlingInWaterAnimationState.stop();
                this.swimmingAnimationState.startIfNotRunning(this.f_19797_);
            } else if (this.m_20072_()) {
                this.swimmingAnimationState.stop();
                this.idlingInWaterAnimationState.startIfNotRunning(this.f_19797_);
            } else {
                this.swimmingAnimationState.stop();
                this.idlingInWaterAnimationState.stop();
            }
        }
        super.m_8119_();
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (f_19806_.equals(data)) {
            if (this.isInPose(Pose.LONG_JUMPING)) {
                this.longJumpingAnimationState.start(this.f_19797_);
            } else {
                this.longJumpingAnimationState.stop();
            }
            if (this.isInPose(Poses.CROAKING.get())) {
                this.croakingAnimationState.start(this.f_19797_);
            } else {
                this.croakingAnimationState.stop();
            }
            if (this.isInPose(Poses.USING_TONGUE.get())) {
                this.usingTongueAnimationState.start(this.f_19797_);
            } else {
                this.usingTongueAnimationState.stop();
            }
        }
        super.m_7350_(data);
    }

    public boolean isInPose(Pose pose) {
        return this.m_20089_() == pose;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        Frog frog = (Frog)WBEntityTypes.FROG.get().m_20615_((Level)level);
        if (frog != null) {
            FrogBrain.coolDownLongJump(frog, level.m_5822_());
        }
        return frog;
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean baby) {
    }

    public void m_27563_(ServerLevel level, Animal partner) {
        ServerPlayer player = this.m_27592_();
        if (player == null) {
            player = partner.m_27592_();
        }
        if (player != null) {
            player.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this, partner, null);
        }
        this.m_146762_(6000);
        partner.m_146762_(6000);
        this.m_27594_();
        partner.m_27594_();
        this.m_6274_().m_21879_(WBMemoryModules.IS_PREGNANT.get(), (Object)Unit.INSTANCE);
        level.m_7605_((Entity)this, (byte)18);
        if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        Holder biome = accessor.m_204166_(this.m_142538_());
        if (biome.m_203656_(WBBiomeTags.SPAWNS_COLD_VARIANT_FROGS)) {
            this.setVariant(Variant.COLD);
        } else if (biome.m_203656_(WBBiomeTags.SPAWNS_WARM_VARIANT_FROGS)) {
            this.setVariant(Variant.WARM);
        } else {
            this.setVariant(Variant.TEMPERATE);
        }
        FrogBrain.coolDownLongJump(this, accessor.m_5822_());
        return super.m_6518_(accessor, difficulty, spawnType, groupData, tag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 10.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return WBSoundEvents.FROG_AMBIENT;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return WBSoundEvents.FROG_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return WBSoundEvents.FROG_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(WBSoundEvents.FROG_STEP, 0.15f, 1.0f);
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return super.m_5639_(fallDistance, damageMultiplier) - 5;
    }

    public void m_7023_(Vec3 input) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), input);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(input);
        }
    }

    public boolean m_21481_(BlockPathTypes type) {
        return super.m_21481_(type) && type != BlockPathTypes.WATER_BORDER;
    }

    public static boolean isValidFrogFood(LivingEntity entity) {
        Slime slime;
        return (!(entity instanceof Slime) || (slime = (Slime)entity).m_33632_() == 1) && entity.m_6095_().m_204039_(WBEntityTypeTags.FROG_FOOD);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FrogPathNavigator(this, level);
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD.test(stack);
    }

    public static boolean checkFrogSpawnRules(EntityType<? extends Animal> type, LevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return accessor.m_8055_(pos.m_7495_()).m_204336_(WBBlockTags.FROGS_SPAWNABLE_ON) && Frog.m_186209_((BlockAndTintGetter)accessor, (BlockPos)pos);
    }

    class FrogLookController
    extends LookControl {
        FrogLookController(Mob mobEntity) {
            super(mobEntity);
        }

        protected boolean m_8106_() {
            return Frog.this.getFrogTarget().isEmpty();
        }
    }

    public static enum Variant {
        TEMPERATE(0, "temperate"),
        WARM(1, "warm"),
        COLD(2, "cold");

        private static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant byId(int id) {
            if (id < 0 || id >= VARIANTS.length) {
                id = 0;
            }
            return VARIANTS[id];
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    static class FrogPathNavigator
    extends WaterBoundPathNavigation {
        FrogPathNavigator(Frog frog, Level level) {
            super((Mob)frog, level);
        }

        protected PathFinder m_5532_(int range) {
            this.f_26508_ = new FrogNodeEvaluator(true);
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, range);
        }

        protected boolean m_7632_() {
            return true;
        }

        public boolean m_6342_(BlockPos pos) {
            return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
        }
    }

    static class FrogNodeEvaluator
    extends AmphibiousNodeEvaluator {
        private final BlockPos.MutableBlockPos preferredBlock = new BlockPos.MutableBlockPos();

        public FrogNodeEvaluator(boolean penalizeDeepWater) {
            super(penalizeDeepWater);
        }

        public BlockPathTypes m_8086_(BlockGetter getter, int x, int y, int z) {
            this.preferredBlock.m_122178_(x, y - 1, z);
            BlockState state = getter.m_8055_((BlockPos)this.preferredBlock);
            return state.m_204336_(WBBlockTags.FROG_PREFER_JUMP_TO) ? BlockPathTypes.OPEN : FrogNodeEvaluator.m_77604_((BlockGetter)getter, (BlockPos.MutableBlockPos)this.preferredBlock.m_122173_(Direction.UP));
        }
    }
}

