/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Frog;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.BiasedLongJumpTask;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.Croak;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.FrogEat;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.LayFrogSpawn;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.WalkTowardsLand;
import com.cursedcauldron.wildbackport.common.entities.brain.frog.WalkTowardsWater;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.registry.entity.WBActivities;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Blocks;

public class FrogBrain {
    private static final UniformInt LONG_JUMP_COOLDOWN_RANGE = UniformInt.m_146622_((int)100, (int)140);

    public static void coolDownLongJump(Frog frog, Random random) {
        frog.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)LONG_JUMP_COOLDOWN_RANGE.m_142270_(random));
    }

    public static Brain<?> create(Brain<Frog> brain) {
        FrogBrain.addCoreActivities(brain);
        FrogBrain.addIdleActivities(brain);
        FrogBrain.addSwimActivities(brain);
        FrogBrain.addLaySpawnActivities(brain);
        FrogBrain.addTongueActivities(brain);
        FrogBrain.addLongJumpActivities(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<Frog> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_)));
    }

    private static void addIdleActivities(Brain<Frog> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)new AnimalMakeLove(WBEntityTypes.FROG.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)new StartAttacking(FrogBrain::isNotBreeding, frog -> frog.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)3, (Object)((Object)new WalkTowardsLand(6, 1.0f))), (Object)Pair.of((Object)4, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)1), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)1), (Object)Pair.of((Object)((Object)new Croak()), (Object)3), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(5, 20)), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(WBMemoryModules.IS_IN_WATER.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addSwimActivities(Brain<Frog> brain) {
        brain.m_21903_(WBActivities.SWIM.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)new StartAttacking(FrogBrain::isNotBreeding, frog -> frog.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)3, (Object)((Object)new WalkTowardsLand(8, 1.5f))), (Object)Pair.of((Object)5, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(0.75f), (Object)1), (Object)Pair.of((Object)new RandomStroll(1.0f, true), (Object)1), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)1), (Object)Pair.of((Object)new RunIf(Entity::m_20072_, (Behavior)new DoNothing(30, 60)), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(WBMemoryModules.IS_IN_WATER.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addLaySpawnActivities(Brain<Frog> brain) {
        brain.m_21903_(WBActivities.LAY_SPAWN.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new StartAttacking(FrogBrain::isNotBreeding, frog -> frog.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)2, (Object)((Object)new WalkTowardsWater(8, 1.0f))), (Object)Pair.of((Object)3, (Object)((Object)new LayFrogSpawn(WBBlocks.FROGSPAWN.get(), WBMemoryModules.IS_PREGNANT.get()))), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.0f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.0f, 3), (Object)1), (Object)Pair.of((Object)((Object)new Croak()), (Object)2), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(5, 20)), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(WBMemoryModules.IS_PREGNANT.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addLongJumpActivities(Brain<Frog> brain) {
        brain.m_21903_(Activity.f_150239_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(LONG_JUMP_COOLDOWN_RANGE, WBSoundEvents.FROG_STEP)), (Object)Pair.of((Object)1, new BiasedLongJumpTask<Frog>(LONG_JUMP_COOLDOWN_RANGE, 2, 4, 1.5f, frog -> WBSoundEvents.FROG_LONG_JUMP, WBBlockTags.FROG_PREFER_JUMP_TO, 0.5f, state -> state.m_60713_(Blocks.f_50196_)))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(WBMemoryModules.IS_IN_WATER.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addTongueActivities(Brain<Frog> brain) {
        brain.m_21895_(WBActivities.TONGUE.get(), 0, ImmutableList.of((Object)new StopAttackingIfTargetInvalid(), (Object)((Object)new FrogEat(WBSoundEvents.FROG_TONGUE, WBSoundEvents.FROG_EAT))), MemoryModuleType.f_26372_);
    }

    private static boolean isNotBreeding(Frog frog) {
        return !frog.m_6274_().m_21874_(MemoryModuleType.f_26375_);
    }

    public static void updateActivities(Frog frog) {
        frog.m_6274_().m_21926_((List)ImmutableList.of((Object)WBActivities.TONGUE.get(), (Object)WBActivities.LAY_SPAWN.get(), (Object)Activity.f_150239_, (Object)WBActivities.SWIM.get(), (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptItems() {
        return Frog.FOOD;
    }
}

