/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FrogJumpToRandomPos<E extends Mob>
extends Behavior<E> {
    private static final List<Integer> ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt cooldown;
    protected final int yRange;
    protected final int xzRange;
    protected final float maxRange;
    protected List<Target> targets = Lists.newArrayList();
    protected Optional<Vec3> lastPos = Optional.empty();
    @Nullable
    protected Vec3 lastTarget;
    protected int tries;
    protected long targetTime;
    private final Function<E, SoundEvent> landingSound;
    private final Predicate<BlockState> landingBlocks;

    public FrogJumpToRandomPos(UniformInt cooldown, int yRange, int xzRange, float range, Function<E, SoundEvent> landingSound, Predicate<BlockState> landingBlocks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), 200);
        this.cooldown = cooldown;
        this.yRange = yRange;
        this.xzRange = xzRange;
        this.maxRange = range;
        this.landingSound = landingSound;
        this.landingBlocks = landingBlocks;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Mob entity) {
        boolean canUse;
        boolean bl = canUse = entity.m_20096_() && !entity.m_20069_() && !entity.m_20077_() && !level.m_8055_(entity.m_142538_()).m_60713_(Blocks.f_50719_);
        if (!canUse) {
            entity.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)(this.cooldown.m_142270_(level.f_46441_) / 2));
        }
        return canUse;
    }

    protected boolean canStillUse(ServerLevel level, Mob entity, long time) {
        boolean canUse;
        boolean bl = canUse = this.lastPos.isPresent() && this.lastPos.get().equals((Object)entity.m_20182_()) && this.tries > 0 && !entity.m_20072_() && (this.lastTarget != null || !this.targets.isEmpty());
        if (!canUse && entity.m_6274_().m_21952_(MemoryModuleType.f_148200_).isEmpty()) {
            entity.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)(this.cooldown.m_142270_(level.f_46441_) / 2));
            entity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        }
        return canUse;
    }

    protected void start(ServerLevel level, E entity, long time) {
        this.lastTarget = null;
        this.tries = 20;
        this.lastPos = Optional.of(entity.m_20182_());
        BlockPos pos = entity.m_142538_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        this.targets = BlockPos.m_121886_((int)(x - this.xzRange), (int)(y - this.yRange), (int)(z - this.xzRange), (int)(x + this.xzRange), (int)(y + this.yRange), (int)(z + this.xzRange)).filter(position -> !position.equals((Object)pos)).map(position -> new Target(position.m_7949_(), Mth.m_14165_((double)pos.m_123331_((Vec3i)position)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    protected void tick(ServerLevel level, E entity, long time) {
        if (this.lastTarget != null) {
            if (time - this.targetTime >= 40L) {
                entity.m_146922_(((Mob)entity).f_20883_);
                entity.m_147244_(true);
                double length = this.lastTarget.m_82553_();
                double height = length + entity.m_182332_();
                entity.m_20256_(this.lastTarget.m_82490_(height / length));
                entity.m_6274_().m_21879_(MemoryModuleType.f_148200_, (Object)true);
                level.m_6269_(null, entity, this.landingSound.apply(entity), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.tries;
            this.pickTarget(level, entity, time);
        }
    }

    protected void pickTarget(ServerLevel level, E entity, long time) {
        while (!this.targets.isEmpty()) {
            Vec3 center;
            Vec3 lastTarget;
            Target target;
            BlockPos pos;
            Optional<Target> jumpTarget = this.jumpTarget(level);
            if (jumpTarget.isEmpty() || !this.canLandOn(level, entity, pos = (target = jumpTarget.get()).getPos()) || (lastTarget = this.getRammingVelocity((Mob)entity, center = Vec3.m_82512_((Vec3i)pos))) == null) continue;
            entity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
            PathNavigation navigation = entity.m_21573_();
            Path path = navigation.m_148218_(pos, 0, 8);
            if (path != null && path.m_77403_()) continue;
            this.lastTarget = lastTarget;
            this.targetTime = time;
            return;
        }
    }

    protected Optional<Target> jumpTarget(ServerLevel level) {
        Optional target = WeightedRandom.m_146317_((Random)level.f_46441_, this.targets);
        target.ifPresent(this.targets::remove);
        return target;
    }

    protected boolean canLandOn(ServerLevel level, E entity, BlockPos pos) {
        BlockPos position = entity.m_142538_();
        int x = position.m_123341_();
        int z = position.m_123343_();
        if (x == pos.m_123341_() && z == pos.m_123343_()) {
            return false;
        }
        if (!entity.m_21573_().m_6342_(pos) && !this.landingBlocks.test(level.m_8055_(pos.m_7495_()))) {
            return false;
        }
        return entity.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)((Mob)entity).f_19853_, (BlockPos.MutableBlockPos)pos.m_122032_())) == 0.0f;
    }

    @Nullable
    protected Vec3 getRammingVelocity(Mob entity, Vec3 pos) {
        ArrayList angles = Lists.newArrayList(ANGLES);
        Collections.shuffle(angles);
        Iterator iterator = angles.iterator();
        while (iterator.hasNext()) {
            int angle = (Integer)iterator.next();
            Vec3 velocity = this.getRammingVelocity(entity, pos, angle);
            if (velocity == null) continue;
            return velocity;
        }
        return null;
    }

    @Nullable
    private Vec3 getRammingVelocity(Mob entity, Vec3 pos, int angle) {
        Vec3 position = entity.m_20182_();
        Vec3 scale = new Vec3(pos.f_82479_ - position.f_82479_, 0.0, pos.f_82481_ - position.f_82481_).m_82541_().m_82490_(0.5);
        pos = pos.m_82546_(scale);
        Vec3 distance = pos.m_82546_(position);
        float maxAngle = (float)angle * (float)Math.PI / 180.0f;
        double xzRange = Math.atan2(distance.f_82481_, distance.f_82479_);
        double yRange = distance.m_82492_(0.0, distance.f_82480_, 0.0).m_82556_();
        double yRadius = Math.sqrt(yRange);
        double i = Math.sin(2.0f * maxAngle);
        double k = Math.pow(Math.cos(maxAngle), 2.0);
        double yMax = Math.sin(maxAngle);
        double xzMax = Math.cos(maxAngle);
        double zOffset = Math.sin(xzRange);
        double xOffset = Math.cos(xzRange);
        double jumpHeight = yRange * 0.08 / (yRadius * i - 2.0 * distance.f_82480_ * k);
        if (jumpHeight < 0.0) {
            return null;
        }
        double range = Math.sqrt(jumpHeight);
        if (range > (double)this.maxRange) {
            return null;
        }
        double xzDistance = range * xzMax;
        double yDistance = range * yMax;
        int radius = Mth.m_14165_((double)(yRadius / xzDistance)) * 2;
        double index = 0.0;
        Vec3 source = null;
        for (int j = 0; j < radius - 1; ++j) {
            double x = (index += yRadius / (double)radius) * xOffset;
            double y = yMax / xzMax * index - Math.pow(index, 2.0) * 0.08 / (2.0 * jumpHeight * Math.pow(xzMax, 2.0));
            double z = index * zOffset;
            Vec3 target = new Vec3(position.f_82479_ + x, position.f_82480_ + y, position.f_82481_ + z);
            if (source != null && !this.canReach(entity, source, target)) {
                return null;
            }
            source = target;
        }
        return new Vec3(xzDistance * xOffset, yDistance, xzDistance * zOffset).m_82490_((double)0.95f);
    }

    private boolean canReach(Mob entity, Vec3 source, Vec3 target) {
        EntityDimensions dimensions = entity.m_6972_(Pose.LONG_JUMPING);
        Vec3 distance = target.m_82546_(source);
        double size = Math.min(dimensions.f_20377_, dimensions.f_20378_);
        int height = Mth.m_14165_((double)(distance.m_82553_() / size));
        Vec3 normal = distance.m_82541_();
        Vec3 vector = source;
        for (int i = 0; i < height; ++i) {
            vector = i == height - 1 ? target : vector.m_82549_(normal.m_82490_(size * (double)0.9f));
            AABB box = dimensions.m_20393_(vector);
            if (entity.f_19853_.m_45756_((Entity)entity, box)) continue;
            return false;
        }
        return true;
    }

    public static class Target
    extends WeightedEntry.IntrusiveBase {
        private final BlockPos pos;

        public Target(BlockPos pos, int weight) {
            super(weight);
            this.pos = pos;
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }
}

