/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class FindRoarTarget<E extends Warden>
extends Behavior<E> {
    private final Function<E, Optional<? extends LivingEntity>> targetFinder;

    public FindRoarTarget(Function<E, Optional<? extends LivingEntity>> targetFinder) {
        super((Map)ImmutableMap.of(WBMemoryModules.ROAR_TARGET.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED));
        this.targetFinder = targetFinder;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E warden) {
        return this.targetFinder.apply(warden).filter(arg_0 -> warden.isValidTarget(arg_0)).isPresent();
    }

    protected void start(ServerLevel level, E warden, long time) {
        this.targetFinder.apply(warden).ifPresent(target -> {
            warden.m_6274_().m_21879_(WBMemoryModules.ROAR_TARGET.get(), target);
            warden.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        });
    }
}

