/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.registry.WBPositionSources;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SerializableUUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;

public class MobPositionSource
implements PositionSource {
    public static final Codec<MobPositionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableUUID.f_123272_.fieldOf("source_entity").forGetter(MobPositionSource::getUuid), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(entityPositionSource -> Float.valueOf(entityPositionSource.yOffset))).apply((Applicative)instance, (uUID, float_) -> new MobPositionSource((Either<Entity, Either<UUID, Integer>>)Either.right((Object)Either.left((Object)uUID)), float_.floatValue())));
    private Either<Entity, Either<UUID, Integer>> source;
    final float yOffset;

    public MobPositionSource(Entity entity, float yOffset) {
        this((Either<Entity, Either<UUID, Integer>>)Either.left((Object)entity), yOffset);
    }

    public MobPositionSource(Either<Entity, Either<UUID, Integer>> sourceEntityId, float yOffset) {
        this.source = sourceEntityId;
        this.yOffset = yOffset;
    }

    public Optional<BlockPos> m_142502_(Level world) {
        if (this.source.left().isEmpty()) {
            this.findEntityInWorld(world);
        }
        return this.source.left().map(entity -> entity.m_142538_().m_142022_(0.0, (double)this.yOffset, 0.0));
    }

    private void findEntityInWorld(Level world) {
        ((Optional)this.source.map(Optional::of, either -> Optional.ofNullable((Entity)either.map(uuid -> {
            Entity entity;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                entity = serverLevel.m_8791_(uuid);
            } else {
                entity = null;
            }
            return entity;
        }, arg_0 -> ((Level)world).m_6815_(arg_0))))).ifPresent(entity -> {
            this.source = Either.left((Object)entity);
        });
    }

    public PositionSourceType<?> m_142510_() {
        return WBPositionSources.MOB.get();
    }

    private UUID getUuid() {
        return (UUID)this.source.map(Entity::m_142081_, either -> (UUID)either.map(Function.identity(), integer -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    int getEntityId() {
        return (Integer)this.source.map(Entity::m_142049_, either -> (Integer)either.map(uUID -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    public static class Type
    implements PositionSourceType<MobPositionSource> {
        public MobPositionSource read(FriendlyByteBuf buf) {
            return new MobPositionSource((Either<Entity, Either<UUID, Integer>>)Either.right((Object)Either.right((Object)buf.m_130242_())), buf.readFloat());
        }

        public void write(FriendlyByteBuf buf, MobPositionSource source) {
            buf.m_130130_(source.getEntityId());
            buf.writeFloat(source.yOffset);
        }

        public Codec<MobPositionSource> m_142341_() {
            return CODEC;
        }
    }
}

