/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.access.WardenTracker;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WardenSpawnTracker {
    public static final Codec<WardenSpawnTracker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("ticks_since_last_warning").orElse((Object)0).forGetter(tracker -> tracker.ticksSinceLastWarning), (App)ExtraCodecs.f_144628_.fieldOf("warning_level").orElse((Object)0).forGetter(tracker -> tracker.warningLevel), (App)ExtraCodecs.f_144628_.fieldOf("cooldown_ticks").orElse((Object)0).forGetter(tracker -> tracker.cooldownTicks)).apply((Applicative)instance, WardenSpawnTracker::new));
    private int ticksSinceLastWarning;
    private int warningLevel;
    private int cooldownTicks;

    public WardenSpawnTracker(int ticksSinceLastWarning, int warningLevel, int cooldownTicks) {
        this.ticksSinceLastWarning = ticksSinceLastWarning;
        this.warningLevel = warningLevel;
        this.cooldownTicks = cooldownTicks;
    }

    public void tick() {
        if (this.ticksSinceLastWarning >= 12000) {
            this.decreaseWarningCount();
            this.ticksSinceLastWarning = 0;
        } else {
            ++this.ticksSinceLastWarning;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void reset() {
        this.ticksSinceLastWarning = 0;
        this.warningLevel = 0;
        this.cooldownTicks = 0;
    }

    private boolean onCooldown() {
        return this.cooldownTicks > 0;
    }

    public static OptionalInt tryWarn(ServerLevel level, BlockPos pos, ServerPlayer player) {
        if (!WardenSpawnTracker.hasNearbyWarden(level, pos)) {
            List<ServerPlayer> players = WardenSpawnTracker.getNearbyPlayers(level, pos);
            if (!players.contains(player)) {
                players.add(player);
            }
            if (players.stream().anyMatch(playerIn -> WardenTracker.of((Player)playerIn).getWardenSpawnTracker().onCooldown())) {
                return OptionalInt.empty();
            }
            Optional<WardenSpawnTracker> optional = players.stream().map(WardenTracker::getWardenSpawnTracker).max(Comparator.comparingInt(tracker -> tracker.warningLevel));
            WardenSpawnTracker tracker2 = optional.get();
            tracker2.increaseWarningLevel();
            players.forEach(playerIn -> WardenTracker.of((Player)playerIn).getWardenSpawnTracker().copyData(tracker2));
            return OptionalInt.of(tracker2.warningLevel);
        }
        return OptionalInt.empty();
    }

    private static boolean hasNearbyWarden(ServerLevel level, BlockPos pos) {
        AABB box = AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)48.0, (double)48.0, (double)48.0);
        return !level.m_45976_(Warden.class, box).isEmpty();
    }

    private static List<ServerPlayer> getNearbyPlayers(ServerLevel level, BlockPos pos) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        Predicate<ServerPlayer> predicate = player -> player.m_20182_().m_82509_((Position)center, 16.0);
        return level.m_8795_(predicate.and(LivingEntity::m_6084_).and(EntitySelector.f_20408_));
    }

    private void increaseWarningLevel() {
        if (!this.onCooldown()) {
            this.ticksSinceLastWarning = 0;
            this.cooldownTicks = 200;
            this.setWarningLevel(this.getWarningLevel() + 1);
        }
    }

    private void decreaseWarningCount() {
        this.setWarningLevel(this.getWarningLevel() - 1);
    }

    public void setWarningLevel(int warningLevel) {
        this.warningLevel = Mth.m_14045_((int)warningLevel, (int)0, (int)4);
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    private void copyData(WardenSpawnTracker tracker) {
        this.ticksSinceLastWarning = tracker.ticksSinceLastWarning;
        this.warningLevel = tracker.warningLevel;
        this.cooldownTicks = tracker.cooldownTicks;
    }

    public void readTag(CompoundTag tag) {
        if (tag.m_128425_("ticksSinceLastWarning", 99)) {
            this.ticksSinceLastWarning = tag.m_128451_("ticksSinceLastWarning");
            this.warningLevel = tag.m_128451_("warningCount");
            this.cooldownTicks = tag.m_128451_("shriekerCooldownTicks");
        }
    }

    public void writeTag(CompoundTag tag) {
        tag.m_128405_("ticksSinceLastWarning", this.ticksSinceLastWarning);
        tag.m_128405_("warningCount", this.warningLevel);
        tag.m_128405_("shriekerCooldownTicks", this.cooldownTicks);
    }
}

