/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;

public class SculkGrowthFeature
extends Feature<GlowLichenConfiguration> {
    public SculkGrowthFeature(Codec<GlowLichenConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GlowLichenConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        GlowLichenConfiguration config = (GlowLichenConfiguration)context.m_159778_();
        if (!SculkGrowthFeature.isNotAirOrWater(level.m_8055_(pos))) {
            List<Direction> directions = SculkGrowthFeature.getShuffledDirections(config, random);
            if (SculkGrowthFeature.placeGrowthIfPossible(level, pos, level.m_8055_(pos), config, random, directions)) {
                return true;
            }
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            block0: for (Direction direction : directions) {
                mutable.m_122190_((Vec3i)pos);
                List<Direction> filteredDirections = SculkGrowthFeature.getShuffledDirectionsExcept(config, random, direction.m_122424_());
                for (int i = 0; i < config.f_160870_; ++i) {
                    mutable.m_122159_((Vec3i)pos, direction);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (SculkGrowthFeature.isNotAirOrWater(state) && !state.m_60713_(WBBlocks.SCULK_VEIN.get())) continue block0;
                    if (!SculkGrowthFeature.placeGrowthIfPossible(level, (BlockPos)mutable, state, config, random, filteredDirections)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean placeGrowthIfPossible(WorldGenLevel level, BlockPos pos, BlockState state, GlowLichenConfiguration config, Random random, List<Direction> directions) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (Direction direction : directions) {
            BlockState blockState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction));
            if (!blockState.m_204341_(config.f_160875_)) continue;
            SculkVeinBlock veinBlock = (SculkVeinBlock)WBBlocks.SCULK_VEIN.get();
            BlockState veinState = veinBlock.m_153940_(state, (BlockGetter)level, pos, direction);
            if (veinState == null) {
                return false;
            }
            level.m_7731_(pos, veinState, 3);
            level.m_46865_(pos).m_8113_(pos);
            if (random.nextFloat() < config.f_160874_) {
                veinBlock.allGrowTypeGrower.grow(veinState, (LevelAccessor)level, pos, direction, random, true);
            }
            return true;
        }
        return false;
    }

    public static List<Direction> getShuffledDirections(GlowLichenConfiguration config, Random random) {
        ArrayList list = Lists.newArrayList((Iterable)config.f_160876_);
        Collections.shuffle(list, random);
        return list;
    }

    public static List<Direction> getShuffledDirectionsExcept(GlowLichenConfiguration config, Random random, Direction except) {
        List<Direction> list = config.f_160876_.stream().filter(direction -> direction != except).collect(Collectors.toList());
        Collections.shuffle(list, random);
        return list;
    }

    private static boolean isNotAirOrWater(BlockState state) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_49990_);
    }
}

