/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.worldgen.WBTrunkPlacers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class UpwardBranchingTrunk
extends TrunkPlacer {
    public static final Codec<UpwardBranchingTrunk> CODEC = RecordCodecBuilder.create(instance -> UpwardBranchingTrunk.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(placer -> placer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(placer -> Float.valueOf(placer.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(placer -> placer.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).fieldOf("can_grow_through").forGetter(placer -> placer.canGrowThrough))).apply((Applicative)instance, UpwardBranchingTrunk::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    public final HolderSet<Block> canGrowThrough;

    public UpwardBranchingTrunk(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, int height, BlockPos startPos, TreeConfiguration config) {
        ArrayList attachments = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            int yOffset = startPos.m_123342_() + i;
            if (UpwardBranchingTrunk.m_161893_((LevelSimulatedReader)level, replacer, (Random)random, (BlockPos)mutable.m_122178_(startPos.m_123341_(), yOffset, startPos.m_123343_()), (TreeConfiguration)config) && i < height - 1 && random.nextFloat() < this.placeBranchPerLogProbability) {
                Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
                int offset = this.extraBranchLength.m_142270_(random);
                int length = Math.max(0, offset - this.extraBranchLength.m_142270_(random) - 1);
                int steps = this.extraBranchSteps.m_142270_(random);
                this.placeBranch(level, replacer, random, height, config, attachments, mutable, yOffset, direction, length, steps);
            }
            if (i != height - 1) continue;
            attachments.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutable.m_122178_(startPos.m_123341_(), yOffset + 1, startPos.m_123343_()), 0, false));
        }
        return attachments;
    }

    private void placeBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, int height, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> attachments, BlockPos.MutableBlockPos mutable, int yOffset, Direction direction, int length, int steps) {
        int y = yOffset + length;
        int x = mutable.m_123341_();
        int z = mutable.m_123343_();
        for (int l = length; l < height && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int offset = yOffset + l;
            y = offset;
            if (UpwardBranchingTrunk.m_161893_((LevelSimulatedReader)level, replacer, (Random)random, (BlockPos)mutable.m_122178_(x += direction.m_122429_(), offset, z += direction.m_122431_()), (TreeConfiguration)config)) {
                y = offset + 1;
            }
            attachments.add(new FoliagePlacer.FoliageAttachment(mutable.m_7949_(), 0, false));
        }
        if (y - yOffset > 1) {
            BlockPos pos = new BlockPos(x, y, z);
            attachments.add(new FoliagePlacer.FoliageAttachment(pos, 0, false));
            attachments.add(new FoliagePlacer.FoliageAttachment(pos.m_6625_(2), 0, false));
        }
    }

    protected TrunkPlacerType<?> m_7362_() {
        return WBTrunkPlacers.UPWARDS_BRANCHING_TRUNK.get();
    }
}

