/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.api.worldgen;

import com.cursedcauldron.wildbackport.core.api.worldgen.BiomeWriter;
import com.cursedcauldron.wildbackport.core.api.worldgen.forge.BiomeModifierImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeModifier {
    private static final Map<Consumer<BiomeWriter>, ResourceKey<Biome>[]> FEATURES_PER_BIOME = new ConcurrentHashMap<Consumer<BiomeWriter>, ResourceKey<Biome>[]>();
    private static final Map<Consumer<BiomeWriter>, Biome.BiomeCategory[]> FEATURES_PER_CATEGORY = new ConcurrentHashMap<Consumer<BiomeWriter>, Biome.BiomeCategory[]>();
    public static final BiomeModifier INSTANCE = new BiomeModifier();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setup() {
        BiomeModifierImpl.setup();
    }

    public void register(BiomeWriter writer) {
        FEATURES_PER_BIOME.forEach(writer::add);
        FEATURES_PER_CATEGORY.forEach(writer::add);
    }

    @SafeVarargs
    public static void add(Consumer<BiomeWriter> writer, ResourceKey<Biome> ... biomes) {
        FEATURES_PER_BIOME.put(writer, biomes);
    }

    public static void add(Consumer<BiomeWriter> writer, Biome.BiomeCategory ... biomes) {
        FEATURES_PER_CATEGORY.put(writer, biomes);
    }
}

