/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.core.mixin.client;

import com.cursedcauldron.wildbackport.client.animation.api.Animated;
import com.cursedcauldron.wildbackport.client.render.model.Drawable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public abstract class ModelPartMixin
implements Animated,
Drawable {
    @Shadow
    public boolean f_104207_;
    @Shadow
    @Final
    private List<ModelPart.Cube> f_104212_;
    @Shadow
    @Final
    private Map<String, ModelPart> f_104213_;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private PartPose defaultPose = PartPose.f_171404_;
    private boolean skipDraw;

    @Shadow
    public abstract void m_104299_(PoseStack var1);

    @Override
    public PartPose resetToDefault() {
        return this.defaultPose;
    }

    @Override
    public void setDefault(PartPose pose) {
        this.defaultPose = pose;
    }

    @Inject(method={"loadPose"}, at={@At(value="TAIL")})
    private void wb$load(PartPose pose, CallbackInfo ci) {
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleZ = 1.0f;
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void wb$copy(ModelPart part, CallbackInfo ci) {
        this.scaleX(Animated.of(part).scaleX());
        this.scaleY(Animated.of(part).scaleY());
        this.scaleZ(Animated.of(part).scaleZ());
    }

    @Inject(method={"translateAndRotate"}, at={@At(value="TAIL")})
    private void wb$moveAndScale(PoseStack stack, CallbackInfo ci) {
        if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
            stack.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void wb$render(PoseStack pose, VertexConsumer consumer, int light, int delta, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (this.skipDraw()) {
            if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
                pose.m_85836_();
                this.m_104299_(pose);
                for (ModelPart part : this.f_104213_.values()) {
                    part.m_104306_(pose, consumer, light, delta, red, green, blue, alpha);
                }
                pose.m_85849_();
            }
            ci.cancel();
        }
    }

    @Override
    public float scaleX() {
        return this.scaleX;
    }

    @Override
    public void scaleX(float x) {
        this.scaleX = x;
    }

    @Override
    public void scaleXTo(float x) {
        this.scaleX += x;
    }

    @Override
    public float scaleY() {
        return this.scaleY;
    }

    @Override
    public void scaleY(float y) {
        this.scaleY = y;
    }

    @Override
    public void scaleYTo(float y) {
        this.scaleY += y;
    }

    @Override
    public float scaleZ() {
        return this.scaleZ;
    }

    @Override
    public void scaleZ(float z) {
        this.scaleZ = z;
    }

    @Override
    public void scaleZTo(float z) {
        this.scaleZ += z;
    }

    @Override
    public boolean skipDraw() {
        return this.skipDraw;
    }

    @Override
    public void setSkipDraw(boolean skipDraw) {
        this.skipDraw = skipDraw;
    }
}

