/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabLore;
import net.tslat.aoa3.client.gui.hud.RecoilRenderer;
import net.tslat.aoa3.client.gui.hud.toasts.AbilityUnlockToast;
import net.tslat.aoa3.client.gui.hud.toasts.LevelRequirementToast;
import net.tslat.aoa3.client.gui.hud.toasts.ResourceRequirementToast;
import net.tslat.aoa3.client.gui.realmstone.BlankRealmstoneScreen;
import net.tslat.aoa3.client.particle.FlickeringSparklerParticle;
import net.tslat.aoa3.client.particle.FloatingItemFragmentParticle;
import net.tslat.aoa3.client.particle.FreezingSnowflakeParticle;
import net.tslat.aoa3.client.particle.LingeringSparklerParticle;
import net.tslat.aoa3.client.particle.PortalFloaterParticle;
import net.tslat.aoa3.client.particle.RainbowSparklerParticle;
import net.tslat.aoa3.client.particle.SparklerParticle;
import net.tslat.aoa3.client.particle.SwirlyParticle;
import net.tslat.aoa3.client.render.entity.misc.OccultBlockRenderer;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.common.packet.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.content.entity.mob.greckon.SilencerEntity;
import net.tslat.aoa3.content.item.misc.WornBook;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.ClientPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public final class ClientOperations {
    public static final ClientPlayerDataManager CLIENT_PLAYER_DATA = new ClientPlayerDataManager();

    public static Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void displayWornBookGui() {
        ItemStack bookStack;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack itemStack = bookStack = player.m_21205_().m_41720_() == AoAItems.WORN_BOOK.get() ? player.m_21205_() : player.m_21206_();
        if (IntegrationManager.isPatchouliActive()) {
            PatchouliIntegration.openBook(AdventOfAscension.id("worn_book"));
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new BookViewScreen((BookViewScreen.BookAccess)new BookViewScreen.WrittenBookAccess(WornBook.getBook(bookStack))));
        }
    }

    public static void displayBlankRealmstoneGui() {
        Minecraft.m_91087_().m_91152_((Screen)new BlankRealmstoneScreen());
    }

    public static void addRecoil(float recoil, int firingTime) {
        RecoilRenderer.addRecoil(recoil);
    }

    public static void addOccultBlocks(int renderUntil, ArrayList<Pair<BlockPos, BlockState>> blocks) {
        OccultBlockRenderer.addOccultBlocks(renderUntil, blocks);
    }

    public static void registerParticleFactories(ParticleFactoryRegisterEvent ev) {
        ParticleEngine ParticleEngine2 = Minecraft.m_91087_().f_91061_;
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.PORTAL_FLOATER.get(), PortalFloaterParticle.Factory::new);
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.SPARKLER.get(), SparklerParticle.Factory::new);
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.FLICKERING_SPARKLER.get(), FlickeringSparklerParticle.Factory::new);
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.LINGERING_SPARKLER.get(), LingeringSparklerParticle.Factory::new);
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.RAINBOW_SPARKLER.get(), RainbowSparklerParticle.Factory::new);
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.SWIRLY.get(), SwirlyParticle.Factory::new);
        ParticleEngine2.m_107381_((ParticleType)AoAParticleTypes.FLOATING_ITEM_FRAGMENT.get(), (ParticleProvider)new FloatingItemFragmentParticle.Factory());
        ParticleEngine2.m_107378_((ParticleType)AoAParticleTypes.FREEZING_SNOWFLAKE.get(), FreezingSnowflakeParticle.Factory::new);
    }

    public static void addToast(ToastPopupPacket.ToastPopupType type, Object subject, Object value) {
        switch (type) {
            case SKILL_REQUIREMENT: {
                AoASkill skill = AoASkills.getSkill((ResourceLocation)subject);
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new LevelRequirementToast(skill, (Integer)value));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_6352_((Component)LocaleUtil.getLocaleMessage("message.feedback.insufficientLevels", ChatFormatting.RED, new Component[]{skill.getName(), LocaleUtil.numToComponent((Integer)value)}), Util.f_137441_);
                break;
            }
            case RESOURCE_REQUIREMENT: {
                AoAResource resource = AoAResources.getResource((ResourceLocation)subject);
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ResourceRequirementToast(resource, ((Float)value).floatValue()));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_6352_((Component)LocaleUtil.getLocaleMessage("message.feedback.insufficientResource", ChatFormatting.RED, new Component[]{resource.getName(), new TextComponent(NumberUtil.roundToNthDecimalPlace(((Float)value).floatValue(), 2))}), Util.f_137441_);
                break;
            }
            case ABILITY_UNLOCK: {
                AoASkill skill2 = AoASkills.getSkill((ResourceLocation)subject);
                AoAAbility ability = AoAAbilities.getAbility((ResourceLocation)value);
                if (((Boolean)AoAConfig.CLIENT.useToasts.get()).booleanValue()) {
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new AbilityUnlockToast(skill2, ability));
                    break;
                }
                Minecraft.m_91087_().f_91074_.m_6352_((Component)LocaleUtil.getLocaleMessage("message.feedback.abilityUnlocked", ChatFormatting.GREEN, new Component[]{skill2.getName(), ability.getName()}), Util.f_137441_);
            }
        }
    }

    public static void doSilencerSilence(SilencerEntity silencer) {
        if (!SilencerEntity.isClientNearby) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91106_().f_120349_.m_120258_(SoundSource.MASTER) > 0.0f && silencer.m_20280_((Entity)mc.f_91074_) < 64.0) {
                SilencerEntity.isClientNearby = true;
                SilencerEntity.previousGain = mc.m_91106_().f_120349_.f_120221_.m_83744_();
                mc.m_91106_().f_120349_.m_120260_(SoundSource.MASTER, 0.0f);
            }
        }
    }

    public static void syncPatchouliBooks(ArrayList<ResourceLocation> books) {
        AdventGuiTabLore.syncBooks(books);
    }

    public static void adjustPlayerMovement(@Nullable Float x, @Nullable Float y, @Nullable Float z, UpdateClientMovementPacket.Operation operation) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 velocity = player.m_20184_();
        switch (operation) {
            case SET: {
                player.m_20334_(x != null ? (double)x.floatValue() : velocity.m_7096_(), y != null ? (double)y.floatValue() : velocity.m_7098_(), z != null ? (double)z.floatValue() : velocity.m_7094_());
                break;
            }
            case ADD: {
                player.m_20256_(velocity.m_82520_(x != null ? (double)x.floatValue() : 0.0, y != null ? (double)y.floatValue() : 0.0, z != null ? (double)z.floatValue() : 0.0));
                break;
            }
            case MULTIPLY: {
                player.m_20256_(velocity.m_82542_(x != null ? (double)x.floatValue() : 1.0, y != null ? (double)y.floatValue() : 1.0, z != null ? (double)z.floatValue() : 1.0));
                break;
            }
            case MAX: {
                player.m_20334_(x != null ? Math.min((double)x.floatValue(), velocity.m_7096_()) : velocity.m_7096_(), y != null ? Math.min((double)y.floatValue(), velocity.m_7098_()) : velocity.m_7098_(), z != null ? Math.min((double)z.floatValue(), velocity.m_7094_()) : velocity.m_7094_());
                break;
            }
            case MIN: {
                player.m_20334_(x != null ? Math.max((double)x.floatValue(), velocity.m_7096_()) : velocity.m_7096_(), y != null ? Math.max((double)y.floatValue(), velocity.m_7098_()) : velocity.m_7098_(), z != null ? Math.max((double)z.floatValue(), velocity.m_7094_()) : velocity.m_7094_());
            }
        }
    }

    public static boolean harvestAdditionalBlock(BlockPos breakPos) {
        if (Minecraft.m_91087_().f_91072_ == null) {
            return false;
        }
        return Minecraft.m_91087_().f_91072_.m_105267_(breakPos);
    }

    public static Component getPlayerName() {
        return Minecraft.m_91087_().f_91074_.m_5446_();
    }

    public static void addParticle(ParticleOptions particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int amount) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (int i = 0; i < amount; ++i) {
            try {
                level.m_6493_(particle, false, x, y, z, velocityX, velocityY, velocityZ);
                continue;
            }
            catch (Exception ex) {
                Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Unable to spawn particle " + particle, ex);
            }
        }
    }

    public static GameType getGameMode() {
        return Minecraft.m_91087_().f_91072_.m_105295_();
    }

    public static boolean isPressingCrouchKey() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_());
    }

    public static void playSoundFromBuilder(final SoundBuilder soundBuilder) {
        double delay = (double)soundBuilder.getScheduledDelay() + (soundBuilder.getApplyTimeDilation() ? Math.sqrt(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82557_(soundBuilder.getLocation())) * 0.5 : 0.0);
        Object sound = soundBuilder.getFollowingEntity() != null ? new EntityBoundSoundInstance(soundBuilder.getSound(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), soundBuilder.getFollowingEntity()){

            public boolean m_7775_() {
                return soundBuilder.getIsLooping();
            }

            public int m_7766_() {
                return soundBuilder.getLoopDelay();
            }
        } : (soundBuilder.getLocation() != null ? new SimpleSoundInstance(soundBuilder.getSound().m_11660_(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), soundBuilder.getIsLooping(), (int)delay, soundBuilder.getIsInWorld() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, soundBuilder.getLocation().m_7096_(), soundBuilder.getLocation().m_7098_(), soundBuilder.getLocation().m_7094_(), false) : new SimpleSoundInstance(soundBuilder.getSound().m_11660_(), soundBuilder.getCategory(), soundBuilder.getRadius() / 16.0f, soundBuilder.getPitch(), soundBuilder.getIsLooping(), (int)delay, soundBuilder.getIsInWorld() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, false));
        if (delay > 0.0) {
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)sound, (int)delay);
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        }
    }
}

