/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.container.CorruptedTravellerContainer;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;

public class CorruptedTravellerScreen
extends AbstractContainerScreen<CorruptedTravellerContainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("aoa3", "textures/gui/containers/corrupted_traveller.png");
    private static final ArrayList<Item> validFoods = new ArrayList();
    private long nextFoodTick = 0L;
    private Item currentGhostlyFood = Items.f_42410_;
    private final Minecraft mc = Minecraft.m_91087_();

    public CorruptedTravellerScreen(CorruptedTravellerContainer container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        int centerX = (this.f_96543_ - this.f_97726_) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        RenderUtil.prepRenderTexture(guiTexture);
        RenderUtil.renderCustomSizedTexture(matrix, centerX, centerY, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256.0f, 256.0f);
        this.renderGhostlyFood(matrix, centerX, centerY);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        int titleWidth = 4 + this.mc.f_91062_.m_92852_((FormattedText)this.f_96539_);
        RenderUtil.prepRenderTexture(guiTexture);
        RenderUtil.renderCustomSizedTexture(matrix, 28, 4, 176.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        for (int i = 0; i < titleWidth - 2; ++i) {
            RenderUtil.renderCustomSizedTexture(matrix, 29 + i, 4, 177.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        }
        RenderUtil.renderCustomSizedTexture(matrix, 28 + titleWidth - 2, 4, 178.0f, 0.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.f_91062_.m_92889_(matrix, this.f_96539_, 30.0f, 6.0f, ColourUtil.WHITE);
    }

    private void renderGhostlyFood(PoseStack matrix, int centerX, int centerY) {
        Slot slot = ((CorruptedTravellerContainer)this.f_97732_).m_38853_(0);
        if (!slot.m_6657_()) {
            boolean changeLighting;
            ItemStack stack = new ItemStack((ItemLike)this.getGhostlyFood());
            ItemRenderer itemRenderer = this.mc.m_91291_();
            BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
            this.mc.f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderUtil.setRenderingTexture(TextureAtlas.f_118259_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderUtil.resetShaderColour();
            PoseStack modelViewPose = RenderSystem.m_157191_();
            modelViewPose.m_85836_();
            modelViewPose.m_85837_((double)(slot.f_40220_ + centerX), (double)(slot.f_40221_ + centerY), (double)(100.0f + itemRenderer.f_115093_));
            modelViewPose.m_85837_(8.0, 8.0, 0.0);
            modelViewPose.m_85841_(1.0f, -1.0f, 1.0f);
            modelViewPose.m_85841_(16.0f, 16.0f, 16.0f);
            RenderSystem.m_157182_();
            PoseStack poseStack = new PoseStack();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = changeLighting = !model.m_7547_();
            if (changeLighting) {
                Lighting.m_84930_();
            }
            itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, 40, OverlayTexture.f_118083_, model);
            bufferSource.m_109911_();
            RenderSystem.m_69482_();
            if (changeLighting) {
                Lighting.m_84931_();
            }
            modelViewPose.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    private void compileFoodList() {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!item.m_41472_()) continue;
            validFoods.add(item);
        }
    }

    @Nonnull
    private Item getGhostlyFood() {
        long worldTick;
        if (validFoods.isEmpty()) {
            this.compileFoodList();
        }
        if ((worldTick = this.mc.f_91073_.m_46467_()) >= this.nextFoodTick) {
            this.currentGhostlyFood = validFoods.get(RandomUtil.randomNumberUpTo(validFoods.size()));
            this.nextFoodTick = worldTick + 20L;
        }
        return this.currentGhostlyFood;
    }
}

