/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

public final class BossBarRenderer {
    private static final HashMap<String, ResourceLocation> textureCache = new HashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGameOverlayEvent.BossInfo.class, BossBarRenderer::onBossInfoRender);
    }

    private static void onBossInfoRender(RenderGameOverlayEvent.BossInfo ev) {
        if (!ev.isCanceled()) {
            Component nameComponent = ev.getBossEvent().m_18861_();
            PoseStack matrix = ev.getMatrixStack();
            if (nameComponent.m_7360_().isEmpty() || !(nameComponent instanceof TranslatableComponent)) {
                return;
            }
            String id = ((TranslatableComponent)nameComponent).m_131328_();
            if (!id.startsWith("entity.aoa3.")) {
                return;
            }
            Component name = (Component)nameComponent.m_7360_().get(0);
            Minecraft mc = Minecraft.m_91087_();
            Window mainWindow = mc.m_91268_();
            ResourceLocation texture = BossBarRenderer.getTexture(id.substring(12));
            int textureWidth = 196;
            int xPos = mainWindow.m_85445_() / 2 - 100;
            int percentPixels = (int)Math.ceil(ev.getBossEvent().m_142717_() * (float)textureWidth);
            int stringWidth = mc.f_91062_.m_92852_((FormattedText)name);
            int x = mainWindow.m_85445_() / 2 - stringWidth / 2;
            matrix.m_85836_();
            matrix.m_85849_();
            ev.setIncrement(ev.getIncrement() + 5);
            ev.setCanceled(true);
        }
    }

    private static ResourceLocation getTexture(String id) {
        if (textureCache.containsKey(id)) {
            return textureCache.get(id);
        }
        ResourceLocation texture = new ResourceLocation("aoa3", "textures/gui/bossbars/" + id + ".png");
        textureCache.put(id, texture);
        return texture;
    }
}

