/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.RenderUtil;

public class HealthStatusRenderer {
    private static final ResourceLocation HEALTH_BAR = AdventOfAscension.id("textures/gui/overlay/misc/health_bar.png");
    private static float deltaHealth = 0.0f;
    private static int lastHealthTime = 0;
    private static float lastTickHealth = 0.0f;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, RenderGameOverlayEvent.PreLayer.class, HealthStatusRenderer::onHealthRender);
    }

    private static void onHealthRender(RenderGameOverlayEvent.PreLayer ev) {
        ForgeIngameGui gui;
        Minecraft mc;
        HealthRenderType renderType;
        block9: {
            block8: {
                if (ev.isCanceled() || ev.getOverlay() != ForgeIngameGui.PLAYER_HEALTH_ELEMENT) {
                    return;
                }
                renderType = (HealthRenderType)((Object)AoAConfig.CLIENT.healthRenderType.get());
                if (renderType == HealthRenderType.HEARTS) {
                    return;
                }
                mc = Minecraft.m_91087_();
                Gui gui2 = mc.f_91065_;
                if (!(gui2 instanceof ForgeIngameGui)) break block8;
                gui = (ForgeIngameGui)gui2;
                if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) break block9;
            }
            return;
        }
        LocalPlayer player = mc.f_91074_;
        PoseStack matrix = ev.getMatrixStack();
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int top = mc.m_91268_().m_85446_() - gui.left_height;
        gui.left_height += 10;
        gui.setupOverlayRenderState(true, false);
        ev.setCanceled(true);
        mc.m_91307_().m_6180_("health");
        RenderSystem.m_69478_();
        float currentHealth = player.m_21223_();
        float maxHealth = player.m_21233_();
        boolean poisoned = mc.f_91074_.m_21023_(MobEffects.f_19614_);
        boolean withered = mc.f_91074_.m_21023_(MobEffects.f_19615_);
        boolean frozen = mc.f_91074_.m_146890_();
        float absorption = mc.f_91074_.m_6103_();
        if (renderType == HealthRenderType.NUMERIC) {
            HealthStatusRenderer.renderNumeric(matrix, mc, gui, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption);
        } else {
            HealthStatusRenderer.renderBar(matrix, mc, gui, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption);
            if (renderType == HealthRenderType.BAR_NUMERIC) {
                HealthStatusRenderer.renderNumeric(matrix, mc, gui, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption);
            }
        }
        RenderSystem.m_69461_();
        mc.m_91307_().m_7238_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(matrix, (RenderGameOverlayEvent)ev, RenderGameOverlayEvent.ElementType.LAYER));
    }

    private static void renderBar(PoseStack matrix, Minecraft mc, ForgeIngameGui gui, int left, int top, float currentHealth, float maxHealth, boolean poisoned, boolean withered, boolean frozen, float absorption) {
        int uvY = 0;
        if (absorption > 0.0f) {
            uvY = 48;
        } else if (frozen) {
            uvY = 96;
        } else if (withered) {
            uvY = 84;
        } else if (poisoned) {
            uvY = 72;
        } else if (mc.f_91074_.m_21023_(MobEffects.f_19616_)) {
            uvY = 60;
        } else if (mc.f_91073_.m_6106_().m_5466_()) {
            uvY = 108;
        }
        if (!NumberUtil.roundToNthDecimalPlace(lastTickHealth, 1).equals(NumberUtil.roundToNthDecimalPlace(currentHealth, 1))) {
            if (lastTickHealth < currentHealth) {
                if (lastHealthTime == 0) {
                    lastTickHealth = currentHealth;
                    lastHealthTime = mc.f_91074_.f_19797_;
                    return;
                }
                if (deltaHealth < 0.0f) {
                    deltaHealth = 0.0f;
                }
                deltaHealth += currentHealth - lastTickHealth;
            } else {
                if (deltaHealth > 0.0f) {
                    deltaHealth = 0.0f;
                }
                deltaHealth -= lastTickHealth - currentHealth;
            }
            lastHealthTime = mc.f_91074_.f_19797_ + 12;
        }
        if (deltaHealth != 0.0f && lastHealthTime + 20 < mc.f_91074_.f_19797_) {
            deltaHealth = 0.0f;
        }
        lastTickHealth = currentHealth;
        matrix.m_85836_();
        matrix.m_85837_((double)left, (double)top - 1.9, 0.0);
        RenderUtil.prepRenderTexture(HEALTH_BAR);
        float healthWidth = 81.0f * (currentHealth / maxHealth);
        if (currentHealth < maxHealth) {
            RenderUtil.renderCustomSizedTexture(matrix, 0, 0, 0.0f, 12.0f, 81.0f, 12.0f, 81.0f, 120.0f);
        }
        if (!mc.f_91074_.m_6084_()) {
            matrix.m_85849_();
            return;
        }
        RenderUtil.renderCustomSizedTexture(matrix, 0, 0, 0.0f, uvY, healthWidth, 12.0f, 81.0f, 120.0f);
        if (deltaHealth != 0.0f) {
            float x;
            int deltaUvY = deltaHealth < 0.0f ? 24 : 36;
            float deltaWidth = mc.f_91074_.f_19797_ - lastHealthTime < 8 ? 1.0f : (float)(12 - (mc.f_91074_.f_19797_ - 8 - lastHealthTime)) / 12.0f;
            float width = Math.min(Math.abs(deltaHealth), maxHealth) / maxHealth * 81.0f * deltaWidth;
            float f = x = deltaHealth < 0.0f ? healthWidth : healthWidth - width;
            if (deltaHealth < 0.0f && x + width > 81.0f) {
                width = 81.0f - x;
            }
            RenderUtil.renderScaledCustomSizedTexture(matrix, x, 0.0f, x, deltaUvY, width, 12.0f, width, 12.0f, 81.0f, 120.0f);
        }
        RenderUtil.drawColouredBox(matrix, 0, 0, 0, 81, 11, 0x44000000);
        matrix.m_85849_();
    }

    private static void renderNumeric(PoseStack matrix, Minecraft mc, ForgeIngameGui gui, int left, int top, float currentHealth, float maxHealth, boolean poisoned, boolean withered, boolean frozen, float absorption) {
        int healthColour = poisoned ? ColourUtil.RGB(117, 113, 0) : (withered ? ColourUtil.RGB(28, 28, 28) : ColourUtil.RGB(252, 20, 0));
        matrix.m_85836_();
        if (AoAConfig.CLIENT.healthRenderType.get() == HealthRenderType.NUMERIC) {
            if (absorption > 0.0f) {
                left -= 15;
            }
            matrix.m_85837_((double)(left + 15), (double)top + 0.9, 0.0);
            matrix.m_85841_(0.9f, 0.9f, 1.0f);
            if (currentHealth > 0.0f) {
                HealthStatusRenderer.renderHeart(matrix, mc, currentHealth, maxHealth, HealthStatusRenderer.handleHealthState(mc.f_91074_, gui, (int)Math.ceil(currentHealth)), poisoned, withered, frozen, absorption);
                RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, NumberUtil.roundToNthDecimalPlace(currentHealth, 1) + "/" + NumberUtil.roundToNthDecimalPlace(maxHealth, 1), 34.0f, 0.0f, 1.0f, healthColour, RenderUtil.StringRenderType.OUTLINED);
                if (absorption > 0.0f) {
                    RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, "+", 67.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.StringRenderType.OUTLINED);
                    RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, NumberUtil.roundToNthDecimalPlace(absorption, 1), 83.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.StringRenderType.OUTLINED);
                }
            } else {
                RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, LocaleUtil.getLocaleString("deathScreen.title"), AoAConfig.CLIENT.healthRenderType.get() == HealthRenderType.BAR_NUMERIC ? 28.5f : 24.0f, 0.0f, 1.0f, ColourUtil.RGB(150, 0, 0), RenderUtil.StringRenderType.OUTLINED);
            }
        } else {
            gui.left_height += 2;
            if (absorption > 0.0f) {
                left -= 8;
            }
            matrix.m_85837_((double)(left + 17), (double)top + 1.2, 0.0);
            matrix.m_85841_(0.8f, 0.8f, 1.0f);
            if (currentHealth > 0.0f) {
                HealthStatusRenderer.renderHeart(matrix, mc, currentHealth, maxHealth, HealthStatusRenderer.handleHealthState(mc.f_91074_, gui, (int)Math.ceil(currentHealth)), poisoned, withered, frozen, absorption);
                RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, NumberUtil.roundToNthDecimalPlace(currentHealth, 1) + "/" + NumberUtil.roundToNthDecimalPlace(maxHealth, 1), 34.0f, 0.0f, 1.0f, healthColour, RenderUtil.StringRenderType.OUTLINED);
                if (absorption > 0.0f) {
                    RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, "+", 62.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.StringRenderType.OUTLINED);
                    RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, NumberUtil.roundToNthDecimalPlace(absorption, 1), 70.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.StringRenderType.OUTLINED);
                }
            } else {
                RenderUtil.drawCenteredScaledString(matrix, mc.f_91062_, LocaleUtil.getLocaleString("deathScreen.title"), AoAConfig.CLIENT.healthRenderType.get() == HealthRenderType.BAR_NUMERIC ? 28.5f : 24.0f, 0.0f, 1.0f, ColourUtil.RGB(150, 0, 0), RenderUtil.StringRenderType.OUTLINED);
            }
        }
        matrix.m_85849_();
    }

    private static void renderHeart(PoseStack matrix, Minecraft mc, float currentHealth, float maxHealth, boolean flashing, boolean poisoned, boolean withered, boolean frozen, float absorb) {
        int uvX = 16;
        int uvY = mc.f_91073_.m_6106_().m_5466_() ? 45 : 0;
        int y = -1;
        if (absorb <= 0.0f) {
            if (poisoned) {
                uvX += 36;
            } else if (withered) {
                uvX += 72;
            }
        }
        if (currentHealth <= maxHealth * 0.2f && RandomUtil.fiftyFifty()) {
            ++y;
        }
        if (mc.f_91065_.f_92989_ % 25 == 0 && mc.f_91074_.m_21023_(MobEffects.f_19605_)) {
            y -= 2;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        RenderUtil.renderCustomSizedTexture(matrix, 0, y, Gui.HeartType.CONTAINER.m_168734_(false, flashing), uvY, 9.0f, 9.0f, 256.0f, 256.0f);
        if (flashing) {
            RenderUtil.renderCustomSizedTexture(matrix, 0, y, uvX + 54, uvY, 9.0f, 9.0f, 256.0f, 256.0f);
        }
        if (absorb > 0.0f) {
            RenderUtil.renderCustomSizedTexture(matrix, 0, y, uvX + 144, uvY, 9.0f, 9.0f, 256.0f, 256.0f);
        } else if (frozen) {
            RenderUtil.renderCustomSizedTexture(matrix, 0, y, uvX + 162, uvY, 9.0f, 9.0f, 256.0f, 256.0f);
        } else {
            RenderUtil.renderCustomSizedTexture(matrix, 0, y, uvX + (currentHealth >= maxHealth ? 36 : 45), uvY, 9.0f, 9.0f, 256.0f, 256.0f);
        }
    }

    private static boolean handleHealthState(LocalPlayer player, ForgeIngameGui gui, float currentHealth) {
        boolean shouldFlash;
        boolean bl = shouldFlash = gui.f_92976_ > (long)gui.f_92989_ && (gui.f_92976_ - (long)gui.f_92989_) / 3L % 2L == 1L;
        if (currentHealth < (float)gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.f_92989_ + 20;
        } else if (currentHealth > (float)gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.f_92989_ + 10;
        }
        if (Util.m_137550_() - gui.f_92975_ > 1000L) {
            gui.f_92973_ = (int)currentHealth;
            gui.f_92974_ = (int)currentHealth;
            gui.f_92975_ = Util.m_137550_();
        }
        gui.f_92973_ = (int)currentHealth;
        return shouldFlash;
    }

    public static enum HealthRenderType {
        HEARTS,
        BAR,
        NUMERIC,
        BAR_NUMERIC;

    }
}

