/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model;

import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.AdventOfAscension;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;

public abstract class BaseGeoModel<T extends IAnimatable>
extends AnimatedGeoModel<T> {
    private ResourceLocation model;
    private final ResourceLocation texture;
    private ResourceLocation animations;

    public BaseGeoModel(String assetSubpath) {
        this.model = AdventOfAscension.id("geo/" + this.subtype() + "/" + assetSubpath + ".geo.json");
        this.texture = AdventOfAscension.id("textures/" + this.subtype() + "/" + assetSubpath + ".png");
        this.animations = AdventOfAscension.id("animations/" + this.subtype() + "/" + assetSubpath + ".animation.json");
    }

    public BaseGeoModel<T> withModel(String modelPath) {
        this.model = AdventOfAscension.id("geo/" + this.subtype() + "/" + modelPath + ".geo.json");
        return this;
    }

    public BaseGeoModel<T> withAnimations(String modelPath) {
        this.animations = AdventOfAscension.id("animations/" + this.subtype() + "/" + modelPath + ".animation.json");
        return this;
    }

    protected abstract String subtype();

    @Override
    public ResourceLocation getModelLocation(T object) {
        return this.model;
    }

    @Override
    public ResourceLocation getTextureLocation(T object) {
        return this.texture;
    }

    @Override
    public ResourceLocation getAnimationFileLocation(T animatable) {
        return this.animations;
    }
}

