/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;

public class PortalFloaterParticle
extends TextureSheetParticle {
    private final SpriteSet sprite;
    private final double originPosX;
    private final double originPosY;
    private final double originPosZ;

    public PortalFloaterParticle(ClientLevel world, double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, SpriteSet sprite, float red, float green, float blue, float alpha) {
        super(world, posX, posY, posZ, velocityX, velocityY, velocityZ);
        this.sprite = sprite;
        this.originPosX = posX;
        this.originPosY = posY;
        this.originPosZ = posZ;
        this.f_107215_ = velocityX;
        this.f_107216_ = velocityY;
        this.f_107217_ = velocityZ;
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.f_107230_ = alpha;
        this.f_107663_ = this.f_107223_.nextFloat() * 0.07f;
        this.f_107225_ = (int)(Math.random() * 10.0 + 40.0);
        this.m_108335_(this.sprite);
    }

    public float m_5902_(float scaleFactor) {
        float scale = 1.0f - ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_;
        scale = 1.0f - scale * scale;
        return this.f_107663_ * scale;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_6257_(double x, double y, double z) {
        this.m_107259_(this.m_107277_().m_82386_(x, y, z));
        this.m_107275_();
    }

    public void m_5989_() {
        float percentAged = (float)this.f_107224_ / (float)this.f_107225_;
        float ageModifier = 1.0f - (-percentAged + percentAged * percentAged * 2.0f);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107212_ = this.originPosX + this.f_107215_ * (double)ageModifier;
        this.f_107213_ = this.originPosY + this.f_107216_ * (double)ageModifier + (double)(1.0f - percentAged);
        this.f_107214_ = this.originPosZ + this.f_107217_ * (double)ageModifier;
        this.m_108339_(this.sprite);
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public int m_6355_(float partialTick) {
        int initialBrightness = super.m_6355_(partialTick);
        double percentAged = Math.pow((float)this.f_107224_ / (float)this.f_107225_, 3.0);
        int brightnessLowerBits = initialBrightness & 0xFF;
        int brightnessUpperBits = initialBrightness >> 16 & 0xFF;
        brightnessUpperBits = Math.min(brightnessUpperBits + (int)(percentAged * 240.0), 240);
        return brightnessLowerBits | brightnessUpperBits << 16;
    }

    public static class Factory
    implements ParticleProvider<PortalFloaterParticleType.Data> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(PortalFloaterParticleType.Data data, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new PortalFloaterParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprite, data.red, data.green, data.blue, data.alpha);
        }
    }
}

