/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.layer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.client.model.misc.PlayerHaloModel;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.AoAHaloUtil;

public class PlayerHaloRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aoa3", "textures/entity/player/halo_texture.png");
    private static final RenderType TSLAT_HALO_RENDER_TYPE = PlayerHaloRenderLayer.getTslatHaloRenderType();
    private final PlayerHaloModel model;

    public PlayerHaloRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.model = new PlayerHaloModel(modelSet.m_171103_(PlayerHaloModel.LAYER_LOCATION));
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int pPackedLight, AbstractClientPlayer player, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (player.m_108555_() && !player.m_20145_() && ((Boolean)AoAConfig.CLIENT.showPlayerHalos.get()).booleanValue()) {
            AoAHaloUtil.Type chosenHalo = AoAHaloUtil.getHalo(player.m_142081_());
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (chosenHalo == null) {
                return;
            }
            if (chosenHalo == AoAHaloUtil.Type.Tslat) {
                VertexConsumer vertexConsumer = buffer.m_6299_(TSLAT_HALO_RENDER_TYPE);
                this.model.root.m_104315_(((PlayerModel)this.m_117386_()).m_5585_());
                this.model.m_7695_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.1f);
                return;
            }
            switch (chosenHalo) {
                case Donator: {
                    red = 1.0f;
                    green = 1.0f;
                    break;
                }
                case Super_Donator: 
                case Crazy_Donator: {
                    red = 1.0f;
                    break;
                }
                case Staff: {
                    red = 0.6f;
                    green = 1.0f;
                    blue = 1.0f;
                    break;
                }
                case Wiki_Editor: {
                    blue = 1.0f;
                }
            }
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(player)));
            this.model.root.m_104315_(((PlayerModel)this.m_117386_()).m_5585_());
            RenderSystem.m_69478_();
            RenderSystem.m_69465_();
            this.model.m_7695_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, red, green, blue, 0.1f);
            RenderSystem.m_69482_();
            RenderSystem.m_69461_();
        }
    }

    protected ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return TEXTURE;
    }

    private static RenderType getTslatHaloRenderType() {
        RenderStateShard.TransparencyStateShard transparencyState = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_COLOR);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        });
        return RenderType.m_173215_((String)"halo", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172756_)).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(TheEndPortalRenderer.f_112627_, true, false).m_173132_(TheEndPortalRenderer.f_112626_, true, false).m_173132_(TheEndPortalRenderer.f_112626_, true, false).m_173131_()).m_110685_(transparencyState).m_110691_(false));
    }
}

