/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.container;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.container.UtilityBlockContainer;
import net.tslat.aoa3.common.registration.AoAContainers;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;

public class MendingTableContainer
extends UtilityBlockContainer {
    private int totalMaterialCost = 0;

    public MendingTableContainer(int screenId, Inventory plInventory, ContainerLevelAccess functionCaller) {
        super((MenuType)AoAContainers.MENDING_TABLE.get(), screenId, plInventory, functionCaller);
    }

    @Override
    protected Slot initFirstInputSlot() {
        return new Slot(this.inputs, 0, 27, 23){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41763_();
            }
        };
    }

    @Override
    protected Slot initOutputSlot() {
        return new Slot((Container)this.output, 2, 134, 23){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player playerIn) {
                return this.m_6657_();
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                if (MendingTableContainer.this.totalMaterialCost > 0) {
                    ItemStack repairMaterialStack = MendingTableContainer.this.inputs.m_8020_(1);
                    if (!repairMaterialStack.m_41619_() && repairMaterialStack.m_41613_() >= MendingTableContainer.this.totalMaterialCost) {
                        repairMaterialStack.m_41774_(MendingTableContainer.this.totalMaterialCost);
                    } else {
                        MendingTableContainer.this.inputs.m_6836_(1, ItemStack.f_41583_);
                    }
                } else {
                    MendingTableContainer.this.inputs.m_6836_(1, ItemStack.f_41583_);
                }
                MendingTableContainer.this.inputs.m_6836_(0, ItemStack.f_41583_);
            }
        };
    }

    @Override
    public void updateOutput() {
        ItemStack repairStack = this.inputs.m_8020_(0);
        if (repairStack.m_41619_() || !repairStack.m_41763_()) {
            this.resetMendingContainerState();
        } else {
            ItemStack repairMaterial = this.inputs.m_8020_(1);
            if (repairMaterial.m_41619_()) {
                this.resetMendingContainerState();
            } else {
                ItemStack repairedStack = repairStack.m_41777_();
                if (repairMaterial.m_41720_() == AoAItems.MAGIC_REPAIR_DUST.get() || repairMaterial.m_41720_() == AoAItems.MAGIC_MENDING_COMPOUND.get()) {
                    int repairPortionValue;
                    int n = repairPortionValue = repairMaterial.m_41720_() == AoAItems.MAGIC_MENDING_COMPOUND.get() ? repairedStack.m_41773_() : Math.min(repairedStack.m_41773_(), repairedStack.m_41776_() / 5);
                    if (repairPortionValue <= 0) {
                        this.resetMendingContainerState();
                    } else {
                        int repairCount;
                        for (repairCount = 0; repairPortionValue > 0 && repairCount < repairMaterial.m_41613_(); ++repairCount) {
                            repairedStack.m_41721_(repairedStack.m_41773_() - repairPortionValue);
                            repairPortionValue = Math.min(repairedStack.m_41773_(), repairedStack.m_41776_() / 5);
                        }
                        this.totalMaterialCost = repairCount;
                    }
                }
            }
        }
    }

    private void resetMendingContainerState() {
        this.output.m_6836_(0, ItemStack.f_41583_);
        this.totalMaterialCost = 0;
    }

    @Override
    protected Block getBlock() {
        return (Block)AoABlocks.MENDING_TABLE.get();
    }

    public static void openContainer(ServerPlayer player, final BlockPos pos) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("container.aoa3.mending_table");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                return new MendingTableContainer(windowId, inv, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)pos));
            }
        }, (BlockPos)pos);
    }
}

