/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class GunRecoilPacket
implements AoAPacket {
    private final float recoilAmount;
    private final int firingTime;

    public GunRecoilPacket(float recoil, int firingDelay) {
        this.recoilAmount = recoil;
        this.firingTime = firingDelay;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.recoilAmount);
        buffer.writeInt(this.firingTime);
    }

    public static GunRecoilPacket decode(FriendlyByteBuf buffer) {
        return new GunRecoilPacket(buffer.readFloat(), buffer.readInt());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        ClientOperations.addRecoil(this.recoilAmount, this.firingTime);
        context.get().setPacketHandled(true);
    }
}

