/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class SyncAoAAbilityDataPacket
implements AoAPacket {
    private final ResourceLocation skillId;
    private final String abilityUniqueId;
    private final String data;

    private SyncAoAAbilityDataPacket(ResourceLocation skillId, String abilityUniqueId, String data) {
        this.skillId = skillId;
        this.abilityUniqueId = abilityUniqueId;
        this.data = data;
    }

    public SyncAoAAbilityDataPacket(AoAAbility.Instance ability, String data) {
        this.skillId = ability.getSkill().type().getRegistryName();
        this.abilityUniqueId = ability.getUniqueIdentifier();
        this.data = data;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.skillId);
        buffer.m_130070_(this.abilityUniqueId);
        buffer.m_130070_(this.data);
    }

    public static SyncAoAAbilityDataPacket decode(FriendlyByteBuf buffer) {
        return new SyncAoAAbilityDataPacket(buffer.m_130281_(), buffer.m_130277_(), buffer.m_130277_());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            AoASkill.Instance skillInstance = PlayerUtil.getAdventPlayer(((NetworkEvent.Context)context.get()).getSender()).getSkill(AoASkills.getSkill(this.skillId));
            AoAAbility.Instance abilityInstance = skillInstance.getAbilityMap().get(this.abilityUniqueId);
            abilityInstance.receiveInteractionDataFromClient(this.data);
        });
        context.get().setPacketHandled(true);
    }
}

