/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class ToggleAoAAbilityPacket
implements AoAPacket {
    private final AoASkill skill;
    private final String abilityUniqueId;

    public ToggleAoAAbilityPacket(ResourceLocation skillId, String abilityId) {
        this.skill = AoASkills.getSkill(skillId);
        this.abilityUniqueId = abilityId;
    }

    public ToggleAoAAbilityPacket(AoASkill skill, AoAAbility.Instance ability) {
        this.skill = skill;
        this.abilityUniqueId = ability.getUniqueIdentifier();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.skill == null ? new ResourceLocation("", "") : this.skill.getRegistryName());
        buffer.m_130070_(this.abilityUniqueId);
    }

    public static ToggleAoAAbilityPacket decode(FriendlyByteBuf buffer) {
        return new ToggleAoAAbilityPacket(buffer.m_130281_(), buffer.m_130277_());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        if (this.skill != null) {
            context.get().enqueueWork(() -> {
                AoASkill.Instance skillInstance = PlayerUtil.getAdventPlayer(((NetworkEvent.Context)context.get()).getSender()).getSkill(this.skill);
                AoAAbility.Instance abilityInstance = skillInstance.getAbilityMap().get(this.abilityUniqueId);
                if (abilityInstance.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                    abilityInstance.disable(AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED, false);
                } else if (abilityInstance.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED) {
                    abilityInstance.reenable(false);
                }
            });
        }
        context.get().setPacketHandled(true);
    }
}

