/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.enchantment.ArchmageEnchantment;
import net.tslat.aoa3.content.enchantment.BraceEnchantment;
import net.tslat.aoa3.content.enchantment.ControlEnchantment;
import net.tslat.aoa3.content.enchantment.FormEnchantment;
import net.tslat.aoa3.content.enchantment.GreedEnchantment;
import net.tslat.aoa3.content.enchantment.InterventionEnchantment;
import net.tslat.aoa3.content.enchantment.RechargeEnchantment;
import net.tslat.aoa3.content.enchantment.SeverEnchantment;
import net.tslat.aoa3.content.enchantment.ShellEnchantment;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.content.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.content.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.maul.BaseMaul;
import net.tslat.aoa3.content.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;

public final class AoAEnchantments {
    public static final EnchantmentCategory GUN = EnchantmentCategory.create((String)"GUN", item -> item instanceof BaseGun);
    public static final EnchantmentCategory GREATBLADE = EnchantmentCategory.create((String)"GREATBLADE", item -> item instanceof BaseGreatblade);
    public static final EnchantmentCategory SHOTGUN = EnchantmentCategory.create((String)"SHOTGUN", item -> item instanceof BaseShotgun);
    public static final EnchantmentCategory MAUL = EnchantmentCategory.create((String)"MAUL", item -> item instanceof BaseMaul);
    public static final EnchantmentCategory MELEE_WEAPON = EnchantmentCategory.create((String)"MELEE_WEAPON", item -> item instanceof SwordItem || item instanceof BaseMaul);
    public static final EnchantmentCategory STAFF = EnchantmentCategory.create((String)"STAFF", item -> item instanceof BaseStaff);
    public static final EnchantmentCategory AMMO_CONSUMING = EnchantmentCategory.create((String)"AMMO_CONSUMING", item -> item instanceof BaseGun || item instanceof BaseBlaster || item instanceof BaseStaff);
    public static final EnchantmentCategory BULLET_FIRING = EnchantmentCategory.create((String)"BULLET_FIRING", item -> item instanceof BaseGun && !(item instanceof BaseCannon));
    public static final EnchantmentCategory BLASTER = EnchantmentCategory.create((String)"BLASTER", item -> item instanceof BaseBlaster);
    public static final EnchantmentCategory UNSTACKABLE = EnchantmentCategory.create((String)"UNSTACKABLE", item -> item != null && item.getItemStackLimit(new ItemStack((ItemLike)item)) == 0);
    public static final EnchantmentCategory LIGHT_GUN = EnchantmentCategory.create((String)"DUAL_WIELDABLE_GUN", item -> item instanceof BaseGun && !(item instanceof BaseSniper) && !(item instanceof BaseCannon));
    public static final RegistryObject<Enchantment> ARCHMAGE = AoAEnchantments.registerEnchantment("archmage", ArchmageEnchantment::new);
    public static final RegistryObject<Enchantment> BRACE = AoAEnchantments.registerEnchantment("brace", BraceEnchantment::new);
    public static final RegistryObject<Enchantment> CONTROL = AoAEnchantments.registerEnchantment("control", ControlEnchantment::new);
    public static final RegistryObject<Enchantment> FORM = AoAEnchantments.registerEnchantment("form", FormEnchantment::new);
    public static final RegistryObject<Enchantment> GREED = AoAEnchantments.registerEnchantment("greed", GreedEnchantment::new);
    public static final RegistryObject<Enchantment> INTERVENTION = AoAEnchantments.registerEnchantment("intervention", InterventionEnchantment::new);
    public static final RegistryObject<Enchantment> RECHARGE = AoAEnchantments.registerEnchantment("recharge", RechargeEnchantment::new);
    public static final RegistryObject<Enchantment> SEVER = AoAEnchantments.registerEnchantment("sever", SeverEnchantment::new);
    public static final RegistryObject<Enchantment> SHELL = AoAEnchantments.registerEnchantment("shell", ShellEnchantment::new);

    public static void init() {
    }

    private static RegistryObject<Enchantment> registerEnchantment(String id, Supplier<Enchantment> enchantment) {
        return AoARegistries.ENCHANTMENTS.register(id, enchantment);
    }
}

