/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.decoration.banner;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityUtil;

public class BannerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<BannerType> TYPE = EnumProperty.m_61587_((String)"type", BannerType.class);
    private static final VoxelShape MOUNTED_NORTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.15625));
    private static final VoxelShape MOUNTED_SOUTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.84375, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_EAST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.84375, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final VoxelShape MOUNTED_WEST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 0.15625, 1.0, 1.0));
    private static final VoxelShape STANDING_NORTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.1875, 0.0, 0.453125, 0.8125, 1.0, 0.609375));
    private static final VoxelShape STANDING_SOUTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.1875, 0.0, 0.390625, 0.8125, 1.0, 0.546875));
    private static final VoxelShape STANDING_EAST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.390625, 0.0, 0.1875, 0.546875, 1.0, 0.8125));
    private static final VoxelShape STANDING_WEST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.453125, 0.0, 0.1875, 0.609375, 1.0, 0.8125));

    public BannerBlock() {
        super(new BlockUtil.CompactProperties(Material.f_76310_, MaterialColor.f_76404_).stats(0.5f, 1.0f).sound(SoundType.f_56745_).noClip().noOcclusion().get());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)BannerType.MOUNTED))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.m_5776_()) {
            if (state.m_61143_(TYPE) == BannerType.MOUNTED) {
                world.m_46597_(pos.m_7495_(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).m_49966_().m_61124_(TYPE, (Comparable)((Object)BannerType.MOUNTED))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos.m_7495_()).m_76152_() == Fluids.f_76193_)));
            } else {
                world.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)((Block)AoABlocks.BANNER_EXTENSION.get()).m_49966_().m_61124_(TYPE, (Comparable)((Object)BannerType.STANDING))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_)));
            }
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (state.m_61143_(TYPE) == BannerType.MOUNTED) {
            world.m_46597_(pos.m_7495_(), Blocks.f_50016_.m_49966_());
        } else {
            world.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
        }
        super.m_5707_(world, pos, state, player);
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(TYPE) == BannerType.MOUNTED) {
            Direction mountedFace = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return BannerBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_142300_(mountedFace), (Direction)mountedFace.m_122424_()) && world.m_8055_(pos.m_7495_()).m_60767_().m_76336_();
        }
        return world.m_8055_(pos.m_7494_()).m_60767_().m_76336_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return switch (context.m_43719_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST -> (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)BannerType.MOUNTED))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
            case Direction.UP, Direction.DOWN -> (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)BannerType.STANDING))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)EntityUtil.getDirectionFacing((Entity)context.m_43723_(), true))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean mounted = state.m_61143_(TYPE) == BannerType.MOUNTED;
        return switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.SOUTH -> {
                if (mounted) {
                    yield MOUNTED_SOUTH_SHAPE;
                }
                yield STANDING_SOUTH_SHAPE;
            }
            case Direction.EAST -> {
                if (mounted) {
                    yield MOUNTED_EAST_SHAPE;
                }
                yield STANDING_EAST_SHAPE;
            }
            case Direction.WEST -> {
                if (mounted) {
                    yield MOUNTED_WEST_SHAPE;
                }
                yield STANDING_WEST_SHAPE;
            }
            case Direction.NORTH, Direction.UP, Direction.DOWN -> mounted ? MOUNTED_NORTH_SHAPE : STANDING_NORTH_SHAPE;
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.m_61143_(TYPE) == BannerType.MOUNTED) {
            if (!world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).m_60767_().m_76333_()) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        } else if (!world.m_8055_(pos.m_7495_()).m_60767_().m_76333_()) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, HorizontalDirectionalBlock.f_54117_, BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public static enum BannerType implements StringRepresentable
    {
        MOUNTED("mounted"),
        STANDING("standing");

        private final String name;

        private BannerType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

