/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.content.world.teleporter.PortalCoordinatesContainer;
import net.tslat.aoa3.content.world.teleporter.specific.AbyssTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.BarathosTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.CandylandTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.CeleveTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.CreeponiaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.CrysteviaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.DeeplandsTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.DustopiaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.GardenciaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.GreckonTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.HavenTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.IromineTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.LBoreanTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.LelyetiaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.LunalusTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.MysteriumTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.NetherTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.NowhereTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.PrecasiaTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.RunandorTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.ShyrelandsTeleporter;
import net.tslat.aoa3.content.world.teleporter.specific.VoxPondsTeleporter;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class PortalBlock
extends Block {
    private static final VoxelShape X_SHAPE = Shapes.m_83064_((AABB)new AABB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0));
    private static final VoxelShape Z_SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625));
    private final int particleColour;
    private final ResourceKey<Level> world;

    public PortalBlock(ResourceKey<Level> world, MaterialColor mapColour, int particleColour) {
        super(new BlockUtil.CompactProperties(Material.f_76298_, mapColour).unbreakable().light(11).sound(SoundType.f_56744_).noClip().get());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X));
        this.particleColour = particleColour;
        this.world = world;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.Z) {
            return Z_SHAPE;
        }
        return X_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)EntityUtil.getDirectionFacing((Entity)context.m_43723_(), true).m_122434_());
    }

    private boolean isCompatibleNeighbour(Level world, BlockPos pos) {
        BlockState block = world.m_8055_(pos);
        return block.m_60734_() == this || !block.m_60795_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacent, Direction side) {
        if (adjacent.m_60734_() == this) {
            switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)) {
                case X: {
                    Direction.Axis axis = (Direction.Axis)adjacent.m_61143_((Property)BlockStateProperties.f_61364_);
                    if (axis != Direction.Axis.X) break;
                    return true;
                }
                case Z: {
                    Direction.Axis axis = (Direction.Axis)adjacent.m_61143_((Property)BlockStateProperties.f_61364_);
                    if (axis != Direction.Axis.Z) break;
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double posXStart = (float)pos.m_123341_() + rand.nextFloat();
            double posYStart = (float)pos.m_123342_() + rand.nextFloat();
            double posZStart = (float)pos.m_123343_() + rand.nextFloat();
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int randomMod = rand.nextInt(2) * 2 - 1;
            if (world.m_8055_(pos.m_142125_()).m_60734_() != this && world.m_8055_(pos.m_142126_()).m_60734_() != this) {
                posXStart = (double)pos.m_123341_() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.nextFloat() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.m_123343_() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.nextFloat() * 2.0f * (float)randomMod;
            }
            world.m_7106_((ParticleOptions)new PortalFloaterParticleType.Data(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), this.particleColour), posXStart, posYStart, posZStart, motionX, motionY, motionZ);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (this != AoABlocks.NETHER_PORTAL.get()) {
            return;
        }
        if (!world.m_5776_() && !entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if ((Boolean)AoAConfig.SERVER.allowNonPlayerPortalTravel.get() == false & !(entity instanceof Player)) {
                return;
            }
            if (entity.f_19818_ > 0) {
                entity.f_19818_ = 30;
                return;
            }
            if (this.world == null || !world.m_142572_().m_7079_()) {
                return;
            }
            NetherTeleporter teleporter = this.world == Level.f_46429_ ? new NetherTeleporter() : PortalBlock.getTeleporterForWorld(world.m_142572_().m_129880_(this.world));
            PortalCoordinatesContainer portalLoc = null;
            if (entity instanceof Player) {
                ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayer)entity);
                portalLoc = plData.getPortalReturnLocation((ResourceKey<Level>)world.m_46472_());
                ((ServerPlayer)entity).f_8906_.m_9774_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), entity.m_146908_(), entity.m_146909_());
                if (portalLoc != null && world.m_142572_().m_129880_(portalLoc.fromDim) == null) {
                    portalLoc = null;
                }
            } else {
                entity.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
            entity = portalLoc == null ? (world.m_46472_() == this.world ? entity.changeDimension(world.m_142572_().m_129880_(Level.f_46428_), (ITeleporter)teleporter) : entity.changeDimension(world.m_142572_().m_129880_(this.world), (ITeleporter)teleporter)) : (world.m_46472_() != this.world ? entity.changeDimension(world.m_142572_().m_129880_(this.world), (ITeleporter)teleporter) : entity.changeDimension(world.m_142572_().m_129880_(portalLoc.fromDim), (ITeleporter)teleporter));
            if (entity != null) {
                entity.f_19818_ = 100;
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)) {
                    case Z: {
                        yield (BlockState)state.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61364_});
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.m_46859_(pos.m_7494_()) || world.m_46859_(pos.m_7495_())) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
        switch ((Direction.Axis)world.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61364_)) {
            case Z: {
                if (!world.m_46859_(pos.m_142126_()) && !world.m_46859_(pos.m_142125_())) break;
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                break;
            }
            case X: {
                if (!world.m_46859_(pos.m_142127_()) && !world.m_46859_(pos.m_142128_())) break;
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction.Axis facing = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
        switch (facing) {
            case Z: {
                if (this.isCompatibleNeighbour(world, pos.m_7494_()) && this.isCompatibleNeighbour(world, pos.m_7495_()) && this.isCompatibleNeighbour(world, pos.m_142126_()) && this.isCompatibleNeighbour(world, pos.m_142125_())) break;
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                break;
            }
            case X: {
                if (this.isCompatibleNeighbour(world, pos.m_7494_()) && this.isCompatibleNeighbour(world, pos.m_7495_()) && this.isCompatibleNeighbour(world, pos.m_142127_()) && this.isCompatibleNeighbour(world, pos.m_142128_())) break;
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public static ITeleporter getTeleporterForWorld(ServerLevel world) {
        if (!world.m_46472_().m_135782_().m_135827_().equals("aoa3")) {
            return world.m_8871_();
        }
        AoADimensions.AoADimension aoaDim = AoADimensions.getDim((ResourceKey<Level>)world.m_46472_());
        if (aoaDim == null) {
            return world.m_8871_();
        }
        return switch (aoaDim) {
            case AoADimensions.AoADimension.ABYSS -> new AbyssTeleporter();
            case AoADimensions.AoADimension.BARATHOS -> new BarathosTeleporter();
            case AoADimensions.AoADimension.CANDYLAND -> new CandylandTeleporter();
            case AoADimensions.AoADimension.CELEVE -> new CeleveTeleporter();
            case AoADimensions.AoADimension.CREEPONIA -> new CreeponiaTeleporter();
            case AoADimensions.AoADimension.CRYSTEVIA -> new CrysteviaTeleporter();
            case AoADimensions.AoADimension.DEEPLANDS -> new DeeplandsTeleporter();
            case AoADimensions.AoADimension.DUSTOPIA -> new DustopiaTeleporter();
            case AoADimensions.AoADimension.GARDENCIA -> new GardenciaTeleporter();
            case AoADimensions.AoADimension.GRECKON -> new GreckonTeleporter();
            case AoADimensions.AoADimension.HAVEN -> new HavenTeleporter();
            case AoADimensions.AoADimension.IROMINE -> new IromineTeleporter();
            case AoADimensions.AoADimension.LBOREAN -> new LBoreanTeleporter();
            case AoADimensions.AoADimension.LELYETIA -> new LelyetiaTeleporter();
            case AoADimensions.AoADimension.LUNALUS -> new LunalusTeleporter();
            case AoADimensions.AoADimension.MYSTERIUM -> new MysteriumTeleporter();
            case AoADimensions.AoADimension.NOWHERE -> new NowhereTeleporter();
            case AoADimensions.AoADimension.PRECASIA -> new PrecasiaTeleporter();
            case AoADimensions.AoADimension.RUNANDOR -> new RunandorTeleporter();
            case AoADimensions.AoADimension.SHYRELANDS -> new ShyrelandsTeleporter();
            case AoADimensions.AoADimension.VOX_PONDS -> new VoxPondsTeleporter();
            default -> world.m_8871_();
        };
    }
}

