/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.tileentity.LunarCreationTableTileEntity;
import net.tslat.aoa3.util.BlockUtil;

public class LunarCreationTable
extends Block
implements EntityBlock {
    private static final Component CONTAINER_TITLE = new TranslatableComponent("container.aoa3.lunar_creation_table");

    public LunarCreationTable() {
        super(new BlockUtil.CompactProperties(Material.f_76278_, MaterialColor.f_76422_).stats(10.0f, 15.0f).get());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LunarCreationTableTileEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof LunarCreationTableTileEntity) {
                ((LunarCreationTableTileEntity)tile).dropContents(world, pos);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            player.m_5893_(state.m_60750_(world, pos));
            player.m_36220_(Stats.f_12967_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> {
            CraftingMenu container = new CraftingMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos)){

                public void m_6877_(Player player) {
                    LunarCreationTableTileEntity tileEntity = (LunarCreationTableTileEntity)((Object)this.f_39350_.m_39299_(this::getTileEntity, null));
                    if (tileEntity != null) {
                        tileEntity.setContents((List<ItemStack>)this.f_39348_.f_39320_);
                        this.f_39348_.m_6211_();
                    }
                    super.m_6877_(player);
                }

                @Nullable
                private LunarCreationTableTileEntity getTileEntity(Level world, BlockPos pos) {
                    BlockEntity te = world.m_7702_(pos);
                    return te instanceof LunarCreationTableTileEntity ? (LunarCreationTableTileEntity)te : null;
                }

                public void m_6199_(Container inventory) {
                    LunarCreationTableTileEntity tileEntity = (LunarCreationTableTileEntity)((Object)this.f_39350_.m_39299_(this::getTileEntity, null));
                    if (tileEntity != null) {
                        tileEntity.setContents((List<ItemStack>)this.f_39348_.f_39320_);
                    }
                    super.m_6199_(inventory);
                }

                public boolean m_6875_(Player player) {
                    return 1.m_38889_((ContainerLevelAccess)this.f_39350_, (Player)player, (Block)((Block)AoABlocks.LUNAR_CREATION_TABLE.get()));
                }
            };
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof LunarCreationTableTileEntity) {
                NonNullList<ItemStack> cachedContents = ((LunarCreationTableTileEntity)te).getContents();
                for (int i = 0; i < cachedContents.size(); ++i) {
                    container.f_39348_.f_39320_.set(i, (Object)((ItemStack)cachedContents.get(i)));
                }
                container.m_6199_((Container)container.f_39348_);
            }
            return container;
        }, CONTAINER_TITLE);
    }
}

