/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.grass;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.material.MaterialColor;
import net.tslat.aoa3.content.block.generation.grass.GrassBlock;

public class WaterGrassBlock
extends GrassBlock {
    public WaterGrassBlock(MaterialColor mapColour, Supplier<Block> soilBlock, boolean growsInDark) {
        super(mapColour, soilBlock, growsInDark);
    }

    @Override
    public boolean canStayGrass(BlockState grassState, Level world, BlockPos grassPos) {
        return this.hasSufficientLight(grassState, world, grassPos);
    }

    @Override
    public boolean hasSufficientLight(BlockState grassState, Level world, BlockPos grassPos) {
        BlockPos topPos = grassPos.m_7494_();
        BlockState topBlock = world.m_8055_(topPos);
        if (topBlock.m_60734_() == Blocks.f_50125_ && (Integer)topBlock.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (topBlock.m_60819_().m_76186_() == 8) {
            return true;
        }
        return LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)grassState, (BlockPos)grassPos, (BlockState)topBlock, (BlockPos)topPos, (Direction)Direction.UP, (int)topBlock.m_60739_((BlockGetter)world, topPos)) < world.m_7469_();
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (!this.couldBeSnowy(state, (LevelAccessor)world, pos)) {
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            world.m_46597_(pos, ((Block)this.soilBlock.get()).m_49966_());
        } else if (world.m_46803_(pos.m_7494_()) >= 9) {
            BlockState defaultState = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos spreadPos = pos.m_142082_(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (!world.m_8055_(spreadPos).m_60713_(Blocks.f_50493_) || !this.isSnowyAndNotUnderwater(defaultState, (LevelAccessor)world, spreadPos)) continue;
                world.m_46597_(spreadPos, (BlockState)defaultState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(spreadPos.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }

    @Override
    protected boolean couldBeSnowy(BlockState state, LevelAccessor worldReader, BlockPos pos) {
        BlockPos upPos = pos.m_7494_();
        BlockState topBlock = worldReader.m_8055_(upPos);
        if (topBlock.m_60713_(Blocks.f_50125_) && (Integer)topBlock.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (topBlock.m_60819_().m_76186_() == 8) {
            return true;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)topBlock, (BlockPos)upPos, (Direction)Direction.UP, (int)topBlock.m_60739_((BlockGetter)worldReader, upPos));
        return i < worldReader.m_7469_();
    }
}

