/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.ore;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.RandomUtil;

public class OreBlock
extends Block {
    private final int minXp;
    private final int maxXp;

    public OreBlock(MaterialColor mapColour, int minXp, int maxXp, SoundType sound) {
        super(new BlockUtil.CompactProperties(Material.f_76278_, mapColour).stats(5.0f, 10.0f).needsTool().sound(sound).get());
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public OreBlock(MaterialColor mapColour, int minXp, int maxXp) {
        this(mapColour, minXp, maxXp, SoundType.f_56742_);
    }

    public OreBlock(MaterialColor mapColour) {
        this(mapColour, 0, 0, SoundType.f_56742_);
    }

    public OreBlock(MaterialColor mapColour, SoundType sound) {
        this(mapColour, 0, 0, sound);
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        if (silktouch > 0 || this.maxXp == 0) {
            return 0;
        }
        return (int)((float)RandomUtil.randomNumberBetween(this.minXp, this.maxXp) * (1.0f + 0.15f * (float)fortune));
    }
}

