/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.content.entity.ai.mob.FlyingLookRandomlyGoal;
import net.tslat.aoa3.content.entity.ai.mob.FlyingRangedAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.RandomFlyingGoal;
import net.tslat.aoa3.content.entity.ai.movehelper.RoamingFlightMovementController;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PlayerUtil;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;
import software.bernie.aoa3.geckolib3.core.manager.AnimationFactory;

public abstract class AoAFlyingRangedMob
extends FlyingMob
implements Enemy,
RangedAttackMob,
AoARangedAttacker,
IAnimatable {
    private static final EntityDataAccessor<Integer> SHOOT_STATE = SynchedEntityData.m_135353_(AoAFlyingRangedMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean isSlipperyMovement = false;
    private final AnimationFactory animationFactory = new AnimationFactory(this);
    private final HashMap<String, Integer> animationStates = new HashMap(1);

    protected AoAFlyingRangedMob(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new RoamingFlightMovementController((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFlyingGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new FlyingLookRandomlyGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FlyingRangedAttackGoal(this, Math.max(this.getAttackSwingDuration() + 1, 40), 80));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, pl -> pl instanceof Player && PlayerUtil.shouldPlayerBeAffected((Player)pl)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SHOOT_STATE, (Object)0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_21364_ = (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()) * 2.0) / 10.0);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    public int getAttackSwingDuration() {
        return 6;
    }

    public int getPreAttackTime() {
        return 0;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected void onHit(DamageSource source, float amount) {
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    public void m_6504_(@Nonnull LivingEntity target, float bowDamageFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        double distanceFactorX = target.m_20185_() - projectile.m_20185_();
        double distanceFactorY = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - projectile.m_20186_();
        double distanceFactorZ = target.m_20189_() - projectile.m_20189_();
        double hyp = Math.sqrt(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ) * 0.05;
        if (this.getShootSound() != null) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        projectile.m_6686_(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.f_19853_.m_46791_().m_19028_());
        this.f_19853_.m_7967_((Entity)projectile);
    }

    protected abstract BaseMobProjectile getNewProjectileInstance();

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (switch (projectile.getProjectileType()) {
            case BaseMobProjectile.Type.MAGIC -> DamageUtil.dealMagicDamage((Entity)projectile, (LivingEntity)this, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()), false);
            case BaseMobProjectile.Type.GUN -> DamageUtil.dealGunDamage(target, (LivingEntity)this, projectile, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
            case BaseMobProjectile.Type.PHYSICAL -> DamageUtil.dealRangedDamage(target, (LivingEntity)this, (Entity)projectile, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
            default -> target.m_6469_(DamageSource.m_19340_((Entity)projectile, (LivingEntity)this), (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
        }) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }

    public boolean m_6090_() {
        return true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public int m_21304_() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.m_19586_((LivingEntity)this);
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            time += (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return time;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
    }

    @Override
    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

