/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;

public class BossItemEntity
extends ItemEntity {
    public static final int lifetime = 200;
    private final Player player;

    public BossItemEntity(Level world, double x, double y, double z, ItemStack stack, Player player) {
        super((EntityType)AoAMiscEntities.BOSS_ITEM.get(), world);
        this.lifespan = 200;
        this.player = player;
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
        this.m_6034_(x, y, z);
        this.m_32045_(stack);
        this.m_20334_(this.f_19796_.nextDouble() * 0.2 - 0.1, 0.2, this.f_19796_.nextDouble() * 0.2 - 0.1);
    }

    public BossItemEntity(EntityType<? extends ItemEntity> entityType, Level world) {
        super(entityType, world);
        this.lifespan = 200;
        this.player = null;
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_ && !this.m_32063_() && player.m_142081_().equals(this.m_32056_())) {
            ItemStack stack = this.m_32055_();
            int stackSize = stack.m_41613_();
            int hookResult = ForgeEventFactory.onItemPickup((ItemEntity)this, (Player)player);
            if (hookResult < 0) {
                return;
            }
            ItemStack stackCopy = stack.m_41777_();
            if (hookResult == 1 || stackSize <= 0 || player.m_150109_().m_36054_(stack) || stackCopy.m_41613_() > this.m_32055_().m_41613_()) {
                stackCopy.m_41764_(stackCopy.m_41613_() - this.m_32055_().m_41613_());
                ForgeEventFactory.firePlayerItemPickupEvent((Player)player, (ItemEntity)this, (ItemStack)stackCopy);
                if (stack.m_41619_()) {
                    player.m_7938_((Entity)this, stackSize);
                    this.m_146870_();
                    stack.m_41764_(stackSize);
                }
                player.m_6278_(Stats.f_12982_.m_12902_((Object)this.m_32055_().m_41720_()), stackSize);
            }
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifespan == 6000) {
            return;
        }
        if (!(this.f_19853_.f_46443_ || this.player != null && this.m_32055_().m_41720_() instanceof BossSpawningItem)) {
            this.m_146870_();
            return;
        }
        BossSpawningItem bossItem = (BossSpawningItem)this.m_32055_().m_41720_();
        if (this.player instanceof ServerPlayer) {
            if (this.f_19797_ == this.lifespan - 1) {
                if (bossItem.canSpawnHere(this.f_19853_, (ServerPlayer)this.player, this.m_20185_(), this.m_20186_(), this.m_20189_())) {
                    bossItem.spawnBoss(this.f_19853_, (ServerPlayer)this.player, this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_146870_();
                } else {
                    this.lifespan = 6000;
                }
            }
            return;
        }
        if (this.f_19797_ < this.lifespan) {
            bossItem.handleTimerParticles(this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.lifespan, this.f_19797_);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

