/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.content.item.tool.misc.HaulingRod;
import net.tslat.aoa3.data.server.AoAHaulingFishReloadListener;
import net.tslat.aoa3.event.AoAPlayerEvents;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class HaulingFishingBobberEntity
extends FishingHook {
    protected static final EntityDataAccessor<Integer> HOOKED_ENTITY = SynchedEntityData.m_135353_(HaulingFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(HaulingFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final ItemStack rod;
    protected float f_37096_;
    protected float lure;
    protected float fishingBonusMod = 1.0f;
    protected int timeUntilFishSpawn = -1;
    protected Entity hookedEntity = null;
    protected Entity spawnedFish = null;
    protected long hookTime = 0L;
    protected double lastFishDist = 0.0;
    protected State state = State.MIDAIR;
    public int ownerId;

    public HaulingFishingBobberEntity(Level world, Player player, double posX, double posY, double posZ) {
        super((EntityType)AoAMiscEntities.REINFORCED_BOBBER.get(), world);
        this.m_6034_(posX, posY, posZ);
        this.m_5602_((Entity)player);
        player.f_36083_ = this;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.rod = null;
        this.f_37096_ = 0.0f;
        this.lure = 0.0f;
        this.ownerId = player.m_142049_();
    }

    public HaulingFishingBobberEntity(Player player, Level world, ItemStack rod) {
        this(player, world, rod, 0.0f, 0.0f);
        this.f_37096_ = this.calculateLuck(player, rod);
        this.lure = this.calculateLure(player, rod);
    }

    public HaulingFishingBobberEntity(Player player, Level world, ItemStack rod, float luck, float lure) {
        super(player, world, 0, 0);
        this.rod = rod;
        this.f_37096_ = luck;
        this.lure = lure;
        this.ownerId = player.m_142049_();
        float castStrength = this.getCastStrength();
        this.m_20256_(this.m_20184_().m_82542_((double)castStrength, (double)castStrength, (double)castStrength));
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(HOOKED_ENTITY, (Object)-1);
        this.m_20088_().m_135372_(STATE, (Object)0);
    }

    protected float calculateLuck(Player player, ItemStack rod) {
        float luck = player.m_36336_();
        luck = rod.m_41720_() instanceof HaulingRod ? (luck += (float)((HaulingRod)rod.m_41720_()).getLuckMod(player, rod)) : (luck += (float)EnchantmentHelper.m_44904_((ItemStack)rod));
        return luck;
    }

    protected float calculateLure(Player player, ItemStack rod) {
        if (rod.m_41720_() instanceof HaulingRod) {
            return ((HaulingRod)rod.m_41720_()).getLureMod(player, rod);
        }
        return EnchantmentHelper.m_44904_((ItemStack)rod);
    }

    protected int minLureTime() {
        return 100;
    }

    protected int maxLureTime() {
        return 700;
    }

    public State getState() {
        return this.state;
    }

    public float getLuck() {
        return this.f_37096_;
    }

    protected void calculateFishingLureBonus() {
        this.fishingBonusMod = 1.0f;
        Holder biome = this.f_19853_.m_204166_(this.m_142538_());
        float temperature = ((Biome)biome.m_203334_()).m_47505_(this.m_142538_());
        if (temperature < 0.15f) {
            this.fishingBonusMod *= 0.9f;
        } else if (temperature > 1.5f) {
            this.fishingBonusMod *= 0.8f;
        }
        if (((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.RAIN) {
            this.fishingBonusMod *= 1.1f;
        }
        if (this.f_19853_.m_46758_(this.m_142538_())) {
            this.fishingBonusMod *= 1.1f;
        }
        this.fishingBonusMod *= this.fishingBonusModForBiomeCategory(Biome.m_204183_((Holder)biome));
        int nearbyFluidBlocks = WorldUtil.getBlocksWithinAABB(this.f_19853_, this.m_142469_().m_82377_(3.0, 2.0, 3.0), (state, pos) -> state.m_60819_().m_205070_(this.getApplicableFluid()) && state.m_60819_().m_76170_()).size();
        if (nearbyFluidBlocks <= 50) {
            this.fishingBonusMod *= 0.5f;
            if (nearbyFluidBlocks < 15) {
                this.fishingBonusMod *= 0.5f;
            }
        }
        this.fishingBonusMod *= 1.0f + (float)nearbyFluidBlocks * 0.0025f;
        this.fishingBonusMod += 0.25f * this.lure;
        if (!WorldUtil.getAllPlayersInRegion(this.f_19853_, this.m_142469_().m_82400_(5.0)).isEmpty()) {
            this.fishingBonusMod *= 0.2f;
        }
    }

    protected float fishingBonusModForBiomeCategory(Biome.BiomeCategory category) {
        return switch (category) {
            case Biome.BiomeCategory.OCEAN, Biome.BiomeCategory.RIVER, Biome.BiomeCategory.SWAMP -> 1.25f;
            case Biome.BiomeCategory.DESERT, Biome.BiomeCategory.THEEND, Biome.BiomeCategory.SAVANNA, Biome.BiomeCategory.MESA, Biome.BiomeCategory.NETHER -> 0.5f;
            default -> 1.0f;
        };
    }

    public void m_19890_(double x, double y, double z, float pitch, float yaw) {
        if (y == (double)this.ownerId) {
            return;
        }
        super.m_19890_(x, y, z, pitch, yaw);
    }

    public void m_8119_() {
        this.handleSuperTick();
        Player player = this.m_37168_();
        if (!this.f_19853_.m_5776_() && !this.checkStillValid(player)) {
            this.m_146870_();
            return;
        }
        if (this.m_20077_() && this.getApplicableFluid() != FluidTags.f_13132_) {
            this.m_146870_();
            return;
        }
        if (!this.f_19853_.m_5776_()) {
            this.updateState();
        }
        if (this.hookedEntity == null) {
            this.checkIfCollided();
        }
        if (!this.f_19853_.m_5776_() && this.m_20182_().m_82557_(player.m_20182_()) > Math.pow(this.getMaxCastDistance() * 2.0f, 2.0)) {
            this.m_146870_();
            return;
        }
        BlockPos pos = this.m_142538_();
        FluidState fluidState = this.f_19853_.m_6425_(pos);
        if (this.state == State.HOOKED_FISH || this.state == State.HOOKED_IN_ENTITY) {
            if (this.hookedEntity != null) {
                this.m_6034_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20227_(0.8) - 0.1, this.hookedEntity.m_20189_());
                if (this.state == State.HOOKED_FISH) {
                    if (!this.f_19853_.m_5776_() && this.hookTime-- <= 0L) {
                        this.stopFishing();
                    } else {
                        if (EntityUtil.isEntityMoving((Entity)player)) {
                            this.hookTime -= 2L;
                        }
                        if (this.hookedEntity instanceof PathfinderMob) {
                            Vec3 targetPos;
                            PathfinderMob creature;
                            if (!this.f_19853_.m_5776_() && (creature = (PathfinderMob)this.hookedEntity).m_21573_().m_26571_() && (targetPos = DefaultRandomPos.m_148407_((PathfinderMob)creature, (int)30, (int)5, (Vec3)player.m_20182_())) != null) {
                                creature.m_21573_().m_26536_(creature.m_21573_().m_7864_(new BlockPos(targetPos), 0), 5.0);
                            }
                        } else if (this.hookedEntity.m_20096_()) {
                            this.stopFishing();
                        } else {
                            this.hookedEntity.m_20256_(this.hookedEntity.m_20184_().m_82492_(0.0, 0.008, 0.0));
                        }
                    }
                }
            }
            return;
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.timeUntilFishSpawn >= 0) {
                if (this.timeUntilFishSpawn-- == 0) {
                    this.spawnFish((ServerPlayer)player);
                }
            } else if (this.state == State.IN_FLUID) {
                if (this.spawnedFish != null && this.spawnedFish.m_6084_()) {
                    Entity targetPos = this.spawnedFish;
                    if (targetPos instanceof PathfinderMob) {
                        PathfinderMob creature = (PathfinderMob)targetPos;
                        targetPos = this.m_142538_();
                        PathNavigation navigator = creature.m_21573_();
                        float dist = (float)creature.m_20280_((Entity)this);
                        if (this.lastFishDist - (double)dist < 0.2 || dist <= 5.0f) {
                            EntityUtil.pullEntityIn((Entity)this, (Entity)creature, 0.025f, false);
                            if (dist <= 5.0f) {
                                navigator.m_26573_();
                            }
                        } else if (!creature.m_21691_() || !navigator.m_26567_().equals((Object)targetPos)) {
                            navigator.m_26536_(navigator.m_7864_((BlockPos)targetPos, 0), 0.5);
                        }
                        this.lastFishDist = dist;
                    }
                } else {
                    this.startFishing();
                }
            }
        }
        this.doBobbing(fluidState);
        if (this.state == State.STUCK || this.state == State.MIDAIR) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.08, 0.0));
        }
        if (this.state == State.IN_FLUID) {
            this.m_20256_(this.m_20184_().m_82490_(0.92));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_37283_();
        this.m_20090_();
    }

    protected void doBobbing(FluidState fluidState) {
        if (this.state == State.IN_FLUID) {
            BlockPos pos = this.m_142538_();
            float fluidHeight = fluidState.m_76155_((BlockGetter)this.f_19853_, pos);
            Vec3 vector3d = this.m_20184_();
            double fluidAdjustedHeight = this.m_20186_() + vector3d.f_82480_ - (double)pos.m_123342_() - (double)fluidHeight + 0.1;
            if (Math.abs(fluidAdjustedHeight) < 0.01) {
                fluidAdjustedHeight += Math.signum(fluidAdjustedHeight) * 0.1;
            }
            this.m_20334_(vector3d.f_82479_ * 0.9, vector3d.f_82480_ - fluidAdjustedHeight * (double)this.f_19796_.nextFloat() * 0.2, vector3d.f_82481_ * 0.9);
        }
    }

    protected void updateState() {
        FluidState fluidState;
        State fromState = this.getState();
        if (this.f_19861_ || this.f_19862_) {
            this.state = State.STUCK;
        } else if (this.state == State.STUCK) {
            this.state = State.MIDAIR;
        }
        if (this.hookedEntity != null && this.hookedEntity.m_6084_()) {
            this.state = this.hookedEntity == this.spawnedFish ? State.HOOKED_FISH : State.HOOKED_IN_ENTITY;
        } else if (this.state == State.HOOKED_FISH || this.state == State.HOOKED_IN_ENTITY) {
            this.state = State.MIDAIR;
        }
        if (this.state == State.IN_FLUID && this.spawnedFish != null && this.spawnedFish.m_20280_((Entity)this) < 0.25) {
            this.state = State.HOOKED_FISH;
        }
        if ((fluidState = this.f_19853_.m_6425_(this.m_142538_())).m_205070_(this.getApplicableFluid())) {
            if (this.state == State.MIDAIR) {
                this.state = State.IN_FLUID;
            }
        } else if (this.state == State.IN_FLUID) {
            this.state = State.MIDAIR;
        }
        if (this.getState() != fromState) {
            this.onStateChange(fromState, this.getState());
        }
    }

    protected void onStateChange(State fromState, State toState) {
        if (fromState == State.IN_FLUID) {
            if (this.hookedEntity == null && this.spawnedFish == null) {
                this.stopFishing();
            } else if (toState == State.HOOKED_FISH) {
                this.hookedEntity = this.spawnedFish;
                this.hookTime = 1200L;
            }
        }
        if (toState == State.HOOKED_IN_ENTITY || toState == State.HOOKED_FISH || toState == State.STUCK) {
            this.m_20256_(Vec3.f_82478_);
            if (toState == State.STUCK) {
                this.stopFishing();
            } else {
                this.updateHookedEntity();
            }
        } else if (toState == State.IN_FLUID) {
            this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
            this.startFishing();
        }
        if (fromState == State.IN_FLUID && this.hookedEntity == null && this.spawnedFish == null) {
            this.stopFishing();
        }
        if (fromState == State.HOOKED_FISH || fromState == State.HOOKED_IN_ENTITY) {
            this.updateHookedEntity();
        }
        this.m_20088_().m_135381_(STATE, (Object)this.state.value());
    }

    protected void startFishing() {
        this.stopFishing();
        this.calculateFishingLureBonus();
        int minTime = this.minLureTime();
        int maxTime = this.maxLureTime();
        if (this.fishingBonusMod < 0.9f) {
            minTime = (int)((float)minTime / (this.fishingBonusMod / 2.0f));
            maxTime = (int)((float)maxTime / (this.fishingBonusMod / 3.0f));
        } else {
            maxTime = (int)((float)maxTime / this.fishingBonusMod);
        }
        this.timeUntilFishSpawn = RandomUtil.randomNumberBetween(minTime, Math.max(minTime + 50, maxTime));
    }

    protected void stopFishing() {
        this.timeUntilFishSpawn = -1;
        this.hookTime = 0L;
        this.lastFishDist = 0.0;
        if (this.hookedEntity != null) {
            if (this.hookedEntity == this.spawnedFish) {
                this.hookedEntity.m_146870_();
            }
            this.hookedEntity = null;
        }
        if (this.spawnedFish != null) {
            this.spawnedFish.m_146870_();
            this.spawnedFish = null;
        }
        if (!this.m_146910_()) {
            this.updateHookedEntity();
        }
    }

    protected void spawnFish(ServerPlayer player) {
        Function<Level, Entity> fishFunction = AoAHaulingFishReloadListener.getFishListForBiome((Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_(), false).getRandomElement(player, this.getLuck());
        if (fishFunction != null) {
            Entity entity = fishFunction.apply(player.f_19853_);
            if (entity == null) {
                return;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                BlockPos pos = RandomUtil.getRandomPositionWithinRange(this.m_142538_(), 10, 10, 10, false, this.f_19853_, state -> state.m_60819_().m_76152_() == Fluids.f_76193_, 5);
                mob.m_6034_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
                mob.m_21573_().m_7864_(this.m_142538_(), 0);
                this.f_19853_.m_7967_((Entity)mob);
            } else {
                entity.m_6034_(this.m_20185_(), this.m_20186_() - (double)entity.m_20206_(), this.m_20189_());
                this.f_19853_.m_7967_(entity);
            }
            this.spawnedFish = entity;
            AoAPlayerEvents.handleCustomInteraction(player, "hauling_spawn_fish", this.spawnedFish);
        }
    }

    protected void checkIfCollided() {
        HitResult rayTrace = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        if (rayTrace.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)rayTrace)) {
            this.m_6532_(rayTrace);
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (entity.m_5833_() || !entity.m_6084_()) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            return true;
        }
        if (!entity.m_6087_()) {
            return false;
        }
        Entity owner = this.m_37282_();
        return owner == null || !owner.m_20365_(entity);
    }

    private void handleSuperTick() {
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        if (!this.f_19853_.m_5776_()) {
            this.m_20115_(6, this.m_146886_());
        }
        this.m_6075_();
    }

    protected boolean checkStillValid(Player owner) {
        if (!this.m_6084_()) {
            return false;
        }
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (this.rod == null || this.rod.m_41720_() == Items.f_41852_) {
            return false;
        }
        float maxCastDistance = this.getMaxCastDistance();
        if (owner.m_20280_((Entity)this) > (double)(maxCastDistance * maxCastDistance)) {
            return false;
        }
        return ItemUtil.isHoldingItem((LivingEntity)owner, this.rod.m_41720_());
    }

    protected void m_5790_(EntityHitResult rayTrace) {
        if (!this.f_19853_.m_5776_()) {
            this.hookedEntity = rayTrace.m_82443_();
            this.updateHookedEntity();
        }
    }

    public void m_7350_(EntityDataAccessor<?> param) {
        if (param.equals(HOOKED_ENTITY)) {
            int id = (Integer)this.m_20088_().m_135370_(HOOKED_ENTITY);
            this.hookedEntity = id == -1 ? null : this.f_19853_.m_6815_(id);
        } else if (param.equals(STATE)) {
            this.state = State.byValue((Integer)this.m_20088_().m_135370_(STATE));
        } else if (param.equals((Object)f_19806_)) {
            this.m_6210_();
        }
    }

    protected void updateHookedEntity() {
        if (!this.f_19853_.m_5776_()) {
            this.m_20088_().m_135381_(HOOKED_ENTITY, (Object)(this.hookedEntity == null ? -1 : this.hookedEntity.m_142049_()));
        }
    }

    public EntityType<?> m_6095_() {
        return (EntityType)AoAMiscEntities.REINFORCED_BOBBER.get();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6095_().m_20680_();
    }

    protected float getMaxCastDistance() {
        return 32.0f;
    }

    protected float getCastStrength() {
        return 1.0f;
    }

    public TagKey<Fluid> getApplicableFluid() {
        return FluidTags.f_13131_;
    }

    public void m_7822_(byte p_70103_1_) {
    }

    @Nullable
    public static HaulingFishingBobberEntity handleClientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        Entity owner = world.m_6815_((int)packet.getPosY());
        if (owner instanceof Player) {
            return new HaulingFishingBobberEntity(world, (Player)owner, packet.getPosX(), owner.m_20188_(), packet.getPosZ());
        }
        return null;
    }

    @Nullable
    public Entity m_37170_() {
        return this.hookedEntity;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        this.stopFishing();
    }

    public Packet<?> m_5654_() {
        double y = this.m_20186_();
        this.m_20343_(this.m_20185_(), this.ownerId, this.m_20189_());
        Packet spawnPacket = NetworkHooks.getEntitySpawningPacket((Entity)this);
        this.m_20343_(this.m_20185_(), y, this.m_20189_());
        if (this.ownerId == -1) {
            this.m_146870_();
        }
        return spawnPacket;
    }

    public static enum State {
        MIDAIR(0),
        HOOKED_FISH(1),
        HOOKED_IN_ENTITY(2),
        IN_FLUID(3),
        STUCK(4);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static State byValue(int value) {
            return switch (value) {
                case 0 -> MIDAIR;
                case 1 -> HOOKED_FISH;
                case 2 -> HOOKED_IN_ENTITY;
                case 3 -> IN_FLUID;
                default -> STUCK;
            };
        }
    }
}

