/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.movehelper.UnderwaterWalkingMovementController;
import net.tslat.aoa3.content.entity.base.AoAWaterMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.WorldUtil;

public class PincherEntity
extends AoAWaterMeleeMob {
    public PincherEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new UnderwaterWalkingMovementController((PathfinderMob)this);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (EntityUtil.isNaturalSpawnReason(reason)) {
            BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)this.m_142538_());
            while (!world.m_8055_((BlockPos)spawnPos).m_60767_().m_76334_() && spawnPos.m_123342_() > 0) {
                spawnPos.m_122173_(Direction.DOWN);
            }
            this.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_() + 1, spawnPos.m_123343_());
        }
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.85f;
    }

    @Override
    protected PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_PINCHER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_PINCHER_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_PINCHER_HURT.get();
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, motion);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
            }
        } else {
            super.m_7023_(motion);
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (!this.f_19853_.f_46443_ && this.m_20069_() && target.m_20069_()) {
            WorldUtil.createExplosion((Entity)this, this.f_19853_, 1.5f);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }
}

