/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld.bigday;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.ai.mob.MultiTypeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedRangedAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.StoneGiantRock;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;

public class StoneGiantEntity
extends AoAMeleeMob
implements RangedAttackMob,
AoARangedAttacker {
    public StoneGiantEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 4.34375f;
    }

    @Override
    protected void m_8099_() {
        TelegraphedMeleeAttackGoal<StoneGiantEntity> meleeGoal = new TelegraphedMeleeAttackGoal<StoneGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.m_21304_()).ignoreLineOfSight();
        TelegraphedRangedAttackGoal<StoneGiantEntity> rangedGoal = new TelegraphedRangedAttackGoal<StoneGiantEntity>(this).windUpTime(32).attackFrequency(41, 50).moveSpeedMod(0.75f);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MultiTypeAttackGoal((Object2IntFunction<Goal>)((Object2IntFunction)currentGoal -> {
            LivingEntity target = this.m_5448_();
            if (target == null) {
                return 0;
            }
            if (target.m_20186_() > this.m_20188_()) {
                return 1;
            }
            if (this.m_20280_((Entity)target) > 100.0) {
                return 1;
            }
            return this.m_21573_().m_6570_((Entity)target, 0) == null ? 1 : 0;
        }), meleeGoal, rangedGoal).onChange(goal -> this.setAttackState(goal == meleeGoal ? 0 : 1)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public float getStepHeight() {
        return super.getStepHeight();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_GIANT_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GIANT_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_VERY_HEAVY_STEP.get();
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return this.getAttackState() == 0 ? 13 : 41;
    }

    @Override
    protected int getPreAttackTime() {
        return this.getAttackState() == 0 ? 7 : 32;
    }

    @Override
    protected void onAttack(Entity target) {
        if (this.getAttackState() == 2) {
            ServerParticlePacket packet = new ServerParticlePacket();
            BlockPos targetPos = target.m_142538_().m_7495_();
            BlockPos.m_121940_((BlockPos)targetPos.m_142082_(-1, 0, -1), (BlockPos)targetPos.m_142082_(1, 0, 1)).forEach(pos -> {
                BlockState block = this.f_19853_.m_8055_(pos);
                if (block.m_60767_().m_76337_()) {
                    packet.particle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 3);
                }
            });
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.f_19853_, this.m_20182_(), 20.0);
        }
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkController(this));
        animationData.addAnimationController(AoAAnimations.dynamicAttackController(this, () -> this.getAttackState() == 0 ? AoAAnimations.ATTACK_SLAM : AoAAnimations.ATTACK_THROW));
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        StoneGiantRock projectile = new StoneGiantRock((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.STONE_GIANT_ROCK.get()), this.f_19853_, this, BaseMobProjectile.Type.PHYSICAL);
        projectile.m_146922_(this.m_6080_());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, -1.0, 0.0, 1.5);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.m_146892_(), 1.6, 4 - this.f_19853_.m_46791_().m_19028_());
        projectile.m_20256_(PositionAndMotionUtil.accountForGravity(projectile.m_20182_(), projectile.m_20184_(), target.m_20182_(), ((BaseMobProjectile)projectile).m_7139_()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        this.f_19853_.m_7967_((Entity)projectile);
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        target.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)projectile), (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
    }
}

