/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.gun;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.util.EntityUtil;

public class BaseBullet
extends ThrowableProjectile
implements HardProjectile {
    private float dmgMulti;
    private int lifespan;
    private int pierceCount;
    private int age = 0;
    private BaseGun weapon;
    private Entity lastPierceTarget;
    private InteractionHand hand;
    private Entity cachedOwner = null;

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, float dmgMultiplier, int piercingValue, float velocity) {
        super(entityType, shooter.f_19853_);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = 60;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = InteractionHand.MAIN_HAND;
        this.m_5602_((Entity)shooter);
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
        Vec3 velocityVector = EntityUtil.getVelocityVectorForFacing((Entity)this);
        this.m_6686_(velocityVector.m_7096_(), velocityVector.m_7098_(), velocityVector.m_7094_(), velocity, 0.0f);
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, float dmgMultiplier, int piercingValue, float xMod, float yMod, float zMod) {
        super(entityType, shooter.f_19853_);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
        boolean right = true;
        if (shooter instanceof Player) {
            if (hand == InteractionHand.MAIN_HAND) {
                if (shooter.m_5737_() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.m_5737_() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.m_5602_((Entity)shooter);
        this.m_6686_(-Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(this.m_146909_() * (float)Math.PI / 180.0f)) + xMod, -Mth.m_14031_((float)(this.m_146909_() * (float)Math.PI / 180.0f)) + yMod, Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(this.m_146909_() * (float)Math.PI / 180.0f)) + zMod, 3.0f, 2.0f);
        if (right) {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() - (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() + (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() + (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() - (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, float dmgMultiplier, int piercingValue) {
        super(entityType, shooter.f_19853_);
        boolean right;
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.m_5602_((Entity)shooter);
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
        boolean bl = right = shooter.m_5737_() == HumanoidArm.RIGHT;
        if (shooter instanceof Player) {
            if (hand == InteractionHand.MAIN_HAND) {
                if (shooter.m_5737_() == HumanoidArm.LEFT) {
                    right = false;
                }
            } else if (shooter.m_5737_() == HumanoidArm.RIGHT) {
                right = false;
            }
        }
        this.m_6686_(-Mth.m_14031_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(this.m_146909_() * (float)Math.PI / 180.0f)), -Mth.m_14031_((float)(this.m_146909_() * (float)Math.PI / 180.0f)), Mth.m_14089_((float)(this.m_146908_() * (float)Math.PI / 180.0f)) * Mth.m_14089_((float)(this.m_146909_() * (float)Math.PI / 180.0f)), 3.0f, 0.0f);
        if (right) {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() - (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() + (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.m_6034_(this.m_20184_().m_7096_() * 0.5 + this.m_20185_() + (double)(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f), this.m_20184_().m_7098_() * 0.5 + this.m_20186_() - 0.3, this.m_20184_().m_7094_() * 0.5 + this.m_20189_() - (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableProjectile> entityType, Level world, double x, double y, double z) {
        super(entityType, world);
        this.lifespan = 60;
        this.m_6034_(x, y, z);
    }

    @Nullable
    public Entity m_37282_() {
        if (this.cachedOwner != null && this.cachedOwner.m_6084_()) {
            return this.cachedOwner;
        }
        this.cachedOwner = super.m_37282_();
        return this.cachedOwner;
    }

    public void m_6686_(double directionX, double directionY, double directionZ, float velocity, float inaccuracy) {
        Vec3 motionVec = new Vec3(directionX, directionY, directionZ).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(motionVec);
        double lat = motionVec.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)motionVec.f_82479_, (double)motionVec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)motionVec.f_82480_, (double)lat) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_8060_(BlockHitResult rayTrace) {
        float hardness;
        BlockPos resultPos = rayTrace.m_82425_();
        BlockState bl = this.f_19853_.m_8055_(resultPos);
        bl.m_60669_(this.f_19853_, bl, rayTrace, (Projectile)this);
        if (AoAGameRules.checkDestructiveWeaponPhysics(this.f_19853_) && (hardness = bl.m_60800_((BlockGetter)this.f_19853_, resultPos)) >= 0.0f && hardness <= 0.3f) {
            if (this.f_19796_.nextBoolean()) {
                this.f_19853_.m_46961_(resultPos, true);
            } else {
                this.f_19853_.m_46597_(resultPos, Blocks.f_50016_.m_49966_());
            }
            if (this.f_19796_.nextFloat() > hardness / 1.5f) {
                return;
            }
        }
        if (!bl.m_60767_().m_76334_()) {
            return;
        }
        this.doImpactEffect();
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult rayTrace) {
        Entity entityResult = rayTrace.m_82443_();
        if (entityResult != this.lastPierceTarget) {
            if (this.weapon == null) {
                this.doEntityImpact(entityResult);
            } else if (this.m_37282_() instanceof LivingEntity) {
                this.weapon.doImpactDamage(entityResult, (LivingEntity)this.m_37282_(), this, this.dmgMulti);
            }
            this.doImpactEffect();
            --this.pierceCount;
        }
        if (this.pierceCount >= 0) {
            this.lastPierceTarget = entityResult;
            return;
        }
        this.m_146870_();
    }

    protected void m_6532_(HitResult result) {
        if (this.f_19853_.f_46443_ || result.m_6662_() == HitResult.Type.MISS || !this.m_6084_()) {
            return;
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)result);
        } else {
            this.m_5790_((EntityHitResult)result);
        }
    }

    public void doEntityImpact(Entity target) {
    }

    @Override
    public void doImpactEffect() {
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        AABB boundingBox;
        Vec3 position;
        if (!this.m_6084_()) {
            return;
        }
        Vec3 motion = this.m_20184_();
        if (this.f_19797_ == 1 && !(this.weapon instanceof BaseThrownWeapon)) {
            float mod = this.weapon instanceof BaseSniper ? 0.05f : 0.5f;
            position = new Vec3(this.m_20185_() - motion.m_7096_() * (double)mod, this.m_20186_() - motion.m_7098_() * (double)mod, this.m_20189_() - motion.m_7094_() * (double)mod);
            boundingBox = new AABB(position.m_7096_(), position.m_7098_(), position.m_7094_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        } else {
            boundingBox = this.m_142469_();
            position = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        Vec3 velocityAdjustedPosition = new Vec3(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
        BlockHitResult intersectedBlocksTrace = this.f_19853_.m_45547_(new ClipContext(position, velocityAdjustedPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        velocityAdjustedPosition = intersectedBlocksTrace.m_6662_() != HitResult.Type.MISS ? new Vec3(intersectedBlocksTrace.m_82450_().f_82479_, intersectedBlocksTrace.m_82450_().f_82480_, intersectedBlocksTrace.m_82450_().f_82481_) : new Vec3(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
        Entity shooter = this.m_37282_();
        EntityHitResult entityTrace = ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)position, (Vec3)velocityAdjustedPosition, (AABB)boundingBox.m_82363_(motion.m_7096_(), motion.m_7098_(), motion.m_7094_()).m_82400_(0.5), entity -> entity.m_6084_() && entity.m_6087_() && !entity.m_5833_() && entity != shooter);
        if (entityTrace != null) {
            intersectedBlocksTrace = entityTrace;
        }
        if (intersectedBlocksTrace.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)intersectedBlocksTrace)) {
            this.m_6532_((HitResult)intersectedBlocksTrace);
        }
        if (!this.m_6084_()) {
            return;
        }
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.age > this.lifespan) {
                this.m_146870_();
            } else {
                ++this.age;
            }
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public boolean m_6128_() {
        return true;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public BaseBullet setMaxAge(int maxAge) {
        this.lifespan = maxAge;
        return this;
    }

    public BaseBullet setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    @Nullable
    public BaseGun getWeapon() {
        return this.weapon;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

