/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.mob.mysterium.RunicGolemEntity;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.WorldUtil;

public class RunicBombEntity
extends BaseBullet
implements HardProjectile,
ItemSupplier {
    private float explosionStrength = 1.5f;
    private LivingEntity shooter;

    public RunicBombEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public RunicBombEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.RUNIC_BOMB.get()), world);
    }

    public RunicBombEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.RUNIC_BOMB.get()), shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
    }

    public RunicBombEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.RUNIC_BOMB.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public RunicBombEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.RUNIC_BOMB.get()), world, x, y, z);
    }

    @Override
    public float m_7139_() {
        return 0.1f;
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result instanceof BlockHitResult && this.f_19797_ <= 1 && this.m_37282_() == null) {
            return;
        }
        super.m_6532_(result);
    }

    @Override
    public void doImpactEffect() {
        this.explode();
    }

    @Override
    public void doEntityImpact(Entity target) {
        this.explode();
    }

    private void explode() {
        WorldUtil.createExplosion((Entity)this.shooter, this.f_19853_, (Entity)this, this.explosionStrength);
        for (LivingEntity e : this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_(3.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            EntityUtil.applyPotions((Entity)e, new EffectBuilder(MobEffects.f_19597_, 30).level(100));
            if (!(e instanceof RunicGolemEntity) || !((RunicGolemEntity)e).isShielded()) continue;
            ((RunicGolemEntity)e).deactivateShield();
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)AoAWeapons.RUNIC_BOMB.get());
    }
}

