/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class NecroArmour
extends AdventArmour {
    public NecroArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:necro", 64, new int[]{5, 8, 9, 4}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.NECRO;
    }

    @Override
    public void onPostAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDamageEvent event) {
        if (slots == null && !DamageUtil.isEnvironmentalDamage(event.getSource()) && event.getAmount() > plData.player().m_21223_() && plData.equipment().isCooledDown("necro_armour")) {
            ServerPlayer pl = plData.player();
            event.setAmount(0.0f);
            plData.equipment().setCooldown("necro_armour", 72000);
            pl.m_6472_(DamageSource.f_19318_, 2000.0f);
            if (pl.m_21223_() < 4.0f) {
                pl.m_21153_(4.0f);
            }
            ((ServerLevel)pl.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, pl.m_20185_(), pl.m_142469_().f_82292_, pl.m_20189_(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onPlayerDeath(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDeathEvent event) {
        if (slots != null) {
            int count = slots.size();
            Inventory inv = plData.player().m_150109_();
            for (int inventoryIndex = 0; count > 0 && inventoryIndex < inv.m_6643_(); ++inventoryIndex) {
                ItemStack stack = inv.m_8020_(inventoryIndex);
                if (stack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.INTERVENTION.get()), (ItemStack)stack) != 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44963_, (ItemStack)stack) != 0) continue;
                plData.storeItems(stack);
                inv.m_6836_(inventoryIndex, ItemStack.f_41583_);
                --count;
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.necro_armour.desc.4", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

