/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class SkillCrystal
extends Item {
    private final float denominator;
    private final int lowerLimit = 15;

    public SkillCrystal(float denominator) {
        this(denominator, Rarity.COMMON);
    }

    public SkillCrystal(float denominator, Rarity rarity) {
        super(new Item.Properties().m_41491_(AoAItemGroups.MISC_ITEMS).m_41497_(rarity));
        this.denominator = denominator;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayer)player);
            AoASkill skill = PlayerUtil.getLowestSkillWithLimit(plData, 15);
            if (skill != null) {
                plData.getSkill(skill).adjustXp(PlayerUtil.getXpForFractionOfLevel(plData.getSkill(skill).getLevel(true), 1.0f / this.denominator), false, true);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
            } else {
                PlayerUtil.notifyPlayer((Player)plData.player(), (Component)new TranslatableComponent("message.feedback.item.skillCrystal.levelFail", new Object[]{Integer.toString(15)}));
            }
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillCrystal.desc.1", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.skillCrystal.desc.2", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{new TextComponent(Integer.toString(15))}));
    }
}

