/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.PlayerUtil;

public class AmphibiyteLung
extends BossSpawningItem {
    public AmphibiyteLung() {
        super(() -> null, new ParticleOptions[]{ParticleTypes.f_123795_});
    }

    @Override
    public void handleTimerParticles(ItemEntity entityItem, double posX, double posY, double posZ, int lifespan, int ticksExisted) {
        if (entityItem.m_20069_() && entityItem.m_32055_().m_41613_() == 5) {
            super.handleTimerParticles(entityItem, posX, posY, posZ, lifespan, ticksExisted);
        } else if (entityItem.m_32055_().m_41613_() != 5 || entityItem.f_19797_ > 40 && lifespan != 200) {
            entityItem.lifespan = 6000;
        }
    }

    @Override
    public void spawnBoss(Level world, ServerPlayer summoner, double posX, double posY, double posZ) {
    }

    @Override
    public boolean canSpawnHere(Level world, ServerPlayer player, double posX, double posY, double posZ) {
        if (world.m_8055_(new BlockPos(posX, posY, posZ)).m_60734_() != Blocks.f_49990_) {
            return false;
        }
        if (!this.checkSpawnArea(world, new AABB(posX - 0.5, posY, posZ - 0.5, posX + 0.5, posY + 3.0, posZ + 0.5))) {
            PlayerUtil.notifyPlayer((Player)player, (Component)new TranslatableComponent("message.feedback.spawnBoss.noSpace"));
            return false;
        }
        return true;
    }

    private boolean checkSpawnArea(Level world, AABB boundingBox) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = Mth.m_14107_((double)boundingBox.f_82288_); x < Mth.m_14165_((double)boundingBox.f_82291_); ++x) {
            for (int y = Mth.m_14107_((double)boundingBox.f_82289_); y < Mth.m_14165_((double)boundingBox.f_82292_); ++y) {
                for (int z = Mth.m_14107_((double)boundingBox.f_82290_); z < Mth.m_14165_((double)boundingBox.f_82293_); ++z) {
                    BlockState state = world.m_8055_((BlockPos)checkPos.m_122178_(x, y, z));
                    if (state.m_60795_() || state.m_60819_().m_76152_() != Fluids.f_76191_) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

