/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.misc.pixon.PixonEntity;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class InfusionBowl
extends Item {
    private final int harvestAmount;
    private final int harvestLevelModifier;

    public InfusionBowl(int durability, int harvestAmount, int harvestLevelModifier) {
        super(new Item.Properties().m_41491_(AoAItemGroups.TOOLS).m_41503_(durability));
        this.harvestAmount = harvestAmount;
        this.harvestLevelModifier = harvestLevelModifier;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getHarvestAmount() {
        return this.harvestAmount;
    }

    public int getHarvestReqModifier() {
        return this.harvestLevelModifier;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof PixonEntity)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            PixonEntity pixon = (PixonEntity)target;
            if (!pixon.canHarvest((ServerPlayer)player, stack)) {
                return InteractionResult.PASS;
            }
            LootTable harvestTable = player.m_20194_().m_129898_().m_79217_(pixon.m_5743_());
            ArrayList<ItemStack> harvestStacks = new ArrayList<ItemStack>();
            LootContext lootContext = new LootContext.Builder((ServerLevel)player.f_19853_).m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81455_, (Object)pixon).m_78972_(LootContextParams.f_81460_, (Object)pixon.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.f_19318_).m_78975_(LootContextParamSets.f_81415_);
            for (int harvestCount = 0; harvestCount < this.getHarvestAmount() && pixon.m_21223_() > 0.0f; ++harvestCount) {
                if (!player.m_7500_()) {
                    ItemUtil.damageItem(stack, (LivingEntity)player, 1, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                harvestStacks.addAll(harvestTable.m_79129_(lootContext));
                pixon.m_21153_(pixon.m_21223_() - 7.0f + (float)RandomUtil.randomNumberUpTo(6));
                pixon.m_6598_(player);
            }
            if (!harvestStacks.isEmpty()) {
                ItemUtil.givePlayerMultipleItems(player, harvestStacks);
            }
            if (pixon.m_6084_()) {
                pixon.nextHarvestTick = pixon.f_19853_.m_46467_() + 8L + (long)pixon.m_21187_().nextInt(32);
            } else {
                player.m_36246_(Stats.f_12986_.m_12902_((Object)pixon.m_6095_()));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            player.f_19853_.m_6263_(null, (double)pixon.m_142538_().m_123341_(), (double)pixon.m_142538_().m_123342_(), (double)pixon.m_142538_().m_123343_(), (SoundEvent)AoASounds.ENTITY_PIXON_HARVEST.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.infusionBowl.desc.1", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[0]));
    }
}

