/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.entity.projectile.blaster.LightSparkEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class LightSpark
extends BaseBlaster {
    public LightSpark(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SOUL_SPARK_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.f_19853_.m_7967_((Entity)new LightSparkEntity(shooter, this, 5));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (!EntityUtil.isImmuneToSpecialAttacks(target, shooter)) {
            if (shooter instanceof ServerPlayer && !((ServerPlayer)shooter).m_7500_()) {
                ServerPlayer player = (ServerPlayer)shooter;
                AoAResource.Instance spirit = PlayerUtil.getResource((Player)player, (AoAResource)((Object)AoAResources.SPIRIT.get()));
                if (!spirit.hasAmount(200.0f)) {
                    PlayerUtil.notifyPlayerOfInsufficientResources(player, (AoAResource)((Object)AoAResources.SPIRIT.get()), 200.0f);
                    return false;
                }
                spirit.consume(200.0f, false);
                InteractionHand hand = player.m_7655_();
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() != this) {
                    stack = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                }
                if (stack.m_41720_() != this) {
                    return false;
                }
                ItemUtil.damageItem(stack, shooter, hand);
            }
            target.m_146870_();
            return true;
        }
        return false;
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.f_19853_.f_46443_ && count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
            if (this.getFiringSound() != null) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.fire(stack, player);
            ((Player)player).m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity player, int useTicksRemaining) {
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.specImmune", LocaleUtil.ItemDescriptionType.HARMFUL, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.resource", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{new TextComponent("200"), ((AoAResource)((Object)AoAResources.SPIRIT.get())).getName()}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.fire", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.effect", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{new TextComponent(Double.toString((double)(2000 / this.firingDelay) / 100.0))}));
    }
}

