/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.maul;

import com.google.common.collect.Multimap;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.content.item.weapon.maul.BaseMaul;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ElectronMaul
extends BaseMaul {
    public ElectronMaul() {
        super(25.0f, AttackSpeed.THIRD, 6.5, 1500);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.m_46467_() % 10L == 0L && entity instanceof LivingEntity) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            try {
                if (isSelected) {
                    float currentCalcBuff;
                    float currentKnockbackMod = cap.getValue();
                    if (currentKnockbackMod != (currentCalcBuff = this.getKnockbackMultiplier(entity))) {
                        ((LivingEntity)entity).m_21204_().m_22161_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                        cap.setValue(currentCalcBuff);
                        ((LivingEntity)entity).m_21204_().m_22178_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                    }
                } else if (cap.getValue() != 0.0f && ((LivingEntity)entity).m_21205_().m_41619_()) {
                    ((LivingEntity)entity).m_21204_().m_22161_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                    cap.setValue(0.0f);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, Entity target, LivingEntity attacker, float attackCooldown) {
        VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
        if (cap.getValue() > 0.75f) {
            WorldUtil.spawnLightning((ServerLevel)attacker.f_19853_, (ServerPlayer)attacker, target.m_20185_(), target.m_20186_(), target.m_20189_(), false, false);
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            AoAResource.Instance spirit = PlayerUtil.getResource((Player)player, (AoAResource)((Object)AoAResources.SPIRIT.get()));
            spirit.consume(spirit.getCurrentValue(), true);
        }
    }

    private float getKnockbackMultiplier(Entity holder) {
        if (holder instanceof ServerPlayer) {
            AoAResource.Instance spirit = PlayerUtil.getResource((Player)((ServerPlayer)holder), (AoAResource)((Object)AoAResources.SPIRIT.get()));
            return 1.0f + spirit.getCurrentValue() / spirit.getMaxValue();
        }
        return 1.0f;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> modifierMap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            ItemUtil.setAttribute(modifierMap, Attributes.f_22282_, KNOCKBACK_MODIFIER_UUID, this.getBaseKnockback() * (double)(cap.getValue() == 0.0f ? 1.0f : cap.getValue()));
        }
        return modifierMap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

