/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class BaseStaff<T>
extends Item
implements EnergyProjectileWeapon {
    protected final HashMap<Item, Integer> runes = new HashMap(2);

    public BaseStaff(int durability) {
        super(new Item.Properties().m_41491_(AoAItemGroups.STAVES).m_41503_(durability));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        Item mainItem;
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND && ((mainItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_()) instanceof BaseGun || mainItem instanceof BaseBlaster)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player instanceof ServerPlayer) {
            T preconditionResult = this.checkPreconditions((LivingEntity)player, stack);
            if (preconditionResult == null) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!this.findAndConsumeRunes(this.getRunes(), (ServerPlayer)player, true, stack)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (this.getCastingSound() != null) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getCastingSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.m_36335_().m_41524_((Item)this, 24);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            ItemUtil.damageItem(stack, (LivingEntity)player, hand);
            this.cast(world, stack, (LivingEntity)player, preconditionResult);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean findAndConsumeRunes(HashMap<Item, Integer> runes, ServerPlayer player, boolean allowBuffs, ItemStack staff) {
        return ItemUtil.findAndConsumeRunes(runes, player, allowBuffs, staff);
    }

    @Nullable
    public T checkPreconditions(LivingEntity caster, ItemStack staff) {
        return (T)new Object();
    }

    public HashMap<Item, Integer> getRunes() {
        if (this.runes.isEmpty()) {
            this.populateRunes(this.runes);
        }
        return this.runes;
    }

    @Nullable
    public SoundEvent getCastingSound() {
        return null;
    }

    protected abstract void populateRunes(HashMap<Item, Integer> var1);

    public abstract void cast(Level var1, ItemStack var2, LivingEntity var3, T var4);

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        return true;
    }

    @Override
    public InteractionHand getWeaponHand(LivingEntity holder) {
        return holder.m_21205_().m_41720_() == this || holder.m_21206_().m_41720_() != this ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public float getDmg() {
        return 0.0f;
    }

    public int m_6473_() {
        return 8;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.getDmg() > 0.0f) {
            tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.magic", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(Float.valueOf(this.getDmg()))}));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.staff.runesRequired", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[0]));
        for (Map.Entry<Item, Integer> runeEntry : this.getRunes().entrySet()) {
            tooltip.add((Component)LocaleUtil.getLocaleMessage("items.description.staff.runesRequired.specific", ChatFormatting.WHITE, new Component[]{LocaleUtil.numToComponent(runeEntry.getValue()), LocaleUtil.getLocaleMessage(runeEntry.getKey().m_5524_())}));
        }
    }
}

